/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.model.Privilege;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"principal", "add", "remove"})
public class PermissionsChange {
    public static final String JSON_PROPERTY_PRINCIPAL = "principal";
    private String principal;
    public static final String JSON_PROPERTY_ADD = "add";
    private List<Privilege> add = new ArrayList<Privilege>();
    public static final String JSON_PROPERTY_REMOVE = "remove";
    private List<Privilege> remove = new ArrayList<Privilege>();

    public PermissionsChange principal(String principal) {
        this.principal = principal;
        return this;
    }

    @Nonnull
    @JsonProperty(value="principal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPrincipal() {
        return this.principal;
    }

    @JsonProperty(value="principal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public PermissionsChange add(List<Privilege> add) {
        this.add = add;
        return this;
    }

    public PermissionsChange addAddItem(Privilege addItem) {
        if (this.add == null) {
            this.add = new ArrayList<Privilege>();
        }
        this.add.add(addItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="add")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Privilege> getAdd() {
        return this.add;
    }

    @JsonProperty(value="add")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAdd(List<Privilege> add) {
        this.add = add;
    }

    public PermissionsChange remove(List<Privilege> remove) {
        this.remove = remove;
        return this;
    }

    public PermissionsChange addRemoveItem(Privilege removeItem) {
        if (this.remove == null) {
            this.remove = new ArrayList<Privilege>();
        }
        this.remove.add(removeItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="remove")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Privilege> getRemove() {
        return this.remove;
    }

    @JsonProperty(value="remove")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRemove(List<Privilege> remove) {
        this.remove = remove;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionsChange permissionsChange = (PermissionsChange)o;
        return Objects.equals(this.principal, permissionsChange.principal) && Objects.equals(this.add, permissionsChange.add) && Objects.equals(this.remove, permissionsChange.remove);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.add, this.remove);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PermissionsChange {\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("    add: ").append(this.toIndentedString(this.add)).append("\n");
        sb.append("    remove: ").append(this.toIndentedString(this.remove)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getPrincipal() != null) {
            joiner.add(String.format("%sprincipal%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPrincipal()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAdd() != null) {
            for (i = 0; i < this.getAdd().size(); ++i) {
                if (this.getAdd().get(i) == null) continue;
                joiner.add(String.format("%sadd%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getAdd().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getRemove() != null) {
            for (i = 0; i < this.getRemove().size(); ++i) {
                if (this.getRemove().get(i) == null) continue;
                joiner.add(String.format("%sremove%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf((Object)this.getRemove().get(i)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

