/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.model.ColumnInfo;
import io.unitycatalog.client.model.DataSourceFormat;
import io.unitycatalog.client.model.TableType;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "catalog_name", "schema_name", "table_type", "data_source_format", "columns", "storage_location", "comment", "properties", "owner", "created_at", "created_by", "updated_at", "updated_by", "table_id"})
public class TableInfo {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CATALOG_NAME = "catalog_name";
    private String catalogName;
    public static final String JSON_PROPERTY_SCHEMA_NAME = "schema_name";
    private String schemaName;
    public static final String JSON_PROPERTY_TABLE_TYPE = "table_type";
    private TableType tableType;
    public static final String JSON_PROPERTY_DATA_SOURCE_FORMAT = "data_source_format";
    private DataSourceFormat dataSourceFormat;
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    private List<ColumnInfo> columns = new ArrayList<ColumnInfo>();
    public static final String JSON_PROPERTY_STORAGE_LOCATION = "storage_location";
    private String storageLocation;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, String> properties = new HashMap<String, String>();
    public static final String JSON_PROPERTY_OWNER = "owner";
    private String owner;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private Long createdAt;
    public static final String JSON_PROPERTY_CREATED_BY = "created_by";
    private String createdBy;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updated_by";
    private String updatedBy;
    public static final String JSON_PROPERTY_TABLE_ID = "table_id";
    private String tableId;

    public TableInfo name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public TableInfo catalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    @Nullable
    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public TableInfo schemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    @Nullable
    @JsonProperty(value="schema_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="schema_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public TableInfo tableType(TableType tableType) {
        this.tableType = tableType;
        return this;
    }

    @Nullable
    @JsonProperty(value="table_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty(value="table_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTableType(TableType tableType) {
        this.tableType = tableType;
    }

    public TableInfo dataSourceFormat(DataSourceFormat dataSourceFormat) {
        this.dataSourceFormat = dataSourceFormat;
        return this;
    }

    @Nullable
    @JsonProperty(value="data_source_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DataSourceFormat getDataSourceFormat() {
        return this.dataSourceFormat;
    }

    @JsonProperty(value="data_source_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataSourceFormat(DataSourceFormat dataSourceFormat) {
        this.dataSourceFormat = dataSourceFormat;
    }

    public TableInfo columns(List<ColumnInfo> columns) {
        this.columns = columns;
        return this;
    }

    public TableInfo addColumnsItem(ColumnInfo columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnInfo>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColumns(List<ColumnInfo> columns) {
        this.columns = columns;
    }

    public TableInfo storageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    @Nullable
    @JsonProperty(value="storage_location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStorageLocation() {
        return this.storageLocation;
    }

    @JsonProperty(value="storage_location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public TableInfo comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public TableInfo properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public TableInfo putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public TableInfo owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public TableInfo createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public TableInfo createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public TableInfo updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TableInfo updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updated_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updated_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public TableInfo tableId(String tableId) {
        this.tableId = tableId;
        return this;
    }

    @Nullable
    @JsonProperty(value="table_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTableId() {
        return this.tableId;
    }

    @JsonProperty(value="table_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfo tableInfo = (TableInfo)o;
        return Objects.equals(this.name, tableInfo.name) && Objects.equals(this.catalogName, tableInfo.catalogName) && Objects.equals(this.schemaName, tableInfo.schemaName) && Objects.equals((Object)this.tableType, (Object)tableInfo.tableType) && Objects.equals((Object)this.dataSourceFormat, (Object)tableInfo.dataSourceFormat) && Objects.equals(this.columns, tableInfo.columns) && Objects.equals(this.storageLocation, tableInfo.storageLocation) && Objects.equals(this.comment, tableInfo.comment) && Objects.equals(this.properties, tableInfo.properties) && Objects.equals(this.owner, tableInfo.owner) && Objects.equals(this.createdAt, tableInfo.createdAt) && Objects.equals(this.createdBy, tableInfo.createdBy) && Objects.equals(this.updatedAt, tableInfo.updatedAt) && Objects.equals(this.updatedBy, tableInfo.updatedBy) && Objects.equals(this.tableId, tableInfo.tableId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.catalogName, this.schemaName, this.tableType, this.dataSourceFormat, this.columns, this.storageLocation, this.comment, this.properties, this.owner, this.createdAt, this.createdBy, this.updatedAt, this.updatedBy, this.tableId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableInfo {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    catalogName: ").append(this.toIndentedString(this.catalogName)).append("\n");
        sb.append("    schemaName: ").append(this.toIndentedString(this.schemaName)).append("\n");
        sb.append("    tableType: ").append(this.toIndentedString((Object)this.tableType)).append("\n");
        sb.append("    dataSourceFormat: ").append(this.toIndentedString((Object)this.dataSourceFormat)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    storageLocation: ").append(this.toIndentedString(this.storageLocation)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    tableId: ").append(this.toIndentedString(this.tableId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCatalogName() != null) {
            joiner.add(String.format("%scatalog_name%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCatalogName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSchemaName() != null) {
            joiner.add(String.format("%sschema_name%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSchemaName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTableType() != null) {
            joiner.add(String.format("%stable_type%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getTableType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDataSourceFormat() != null) {
            joiner.add(String.format("%sdata_source_format%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getDataSourceFormat()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getColumns() != null) {
            for (int i = 0; i < this.getColumns().size(); ++i) {
                if (this.getColumns().get(i) == null) continue;
                joiner.add(this.getColumns().get(i).toUrlQueryString(String.format("%scolumns%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getStorageLocation() != null) {
            joiner.add(String.format("%sstorage_location%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getStorageLocation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getComment() != null) {
            joiner.add(String.format("%scomment%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getComment()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getProperties() != null) {
            for (String _key : this.getProperties().keySet()) {
                joiner.add(String.format("%sproperties%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getProperties().get(_key), URLEncoder.encode(String.valueOf(this.getProperties().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getOwner() != null) {
            joiner.add(String.format("%sowner%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getOwner()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screated_at%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCreatedBy() != null) {
            joiner.add(String.format("%screated_by%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCreatedBy()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUpdatedAt() != null) {
            joiner.add(String.format("%supdated_at%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUpdatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUpdatedBy() != null) {
            joiner.add(String.format("%supdated_by%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUpdatedBy()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTableId() != null) {
            joiner.add(String.format("%stable_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTableId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

