/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.ApiException;
import io.unitycatalog.client.ApiResponse;
import io.unitycatalog.client.Pair;
import io.unitycatalog.client.model.CreateModelVersion;
import io.unitycatalog.client.model.FinalizeModelVersion;
import io.unitycatalog.client.model.ListModelVersionsResponse;
import io.unitycatalog.client.model.ModelVersionInfo;
import io.unitycatalog.client.model.UpdateModelVersion;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.function.Consumer;

public class ModelVersionsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public ModelVersionsApi() {
        this(new ApiClient());
    }

    public ModelVersionsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public ModelVersionInfo createModelVersion(CreateModelVersion createModelVersion) throws ApiException {
        ApiResponse<ModelVersionInfo> localVarResponse = this.createModelVersionWithHttpInfo(createModelVersion);
        return localVarResponse.getData();
    }

    public ApiResponse<ModelVersionInfo> createModelVersionWithHttpInfo(CreateModelVersion createModelVersion) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createModelVersionRequestBuilder(createModelVersion);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createModelVersion", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ModelVersionInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ModelVersionInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createModelVersionRequestBuilder(CreateModelVersion createModelVersion) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models/versions";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createModelVersion);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Object deleteModelVersion(String fullName, Long version) throws ApiException {
        ApiResponse<Object> localVarResponse = this.deleteModelVersionWithHttpInfo(fullName, version);
        return localVarResponse.getData();
    }

    public ApiResponse<Object> deleteModelVersionWithHttpInfo(String fullName, Long version) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.deleteModelVersionRequestBuilder(fullName, version);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteModelVersion", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Object>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder deleteModelVersionRequestBuilder(String fullName, Long version) throws ApiException {
        if (fullName == null) {
            throw new ApiException(400, "Missing the required parameter 'fullName' when calling deleteModelVersion");
        }
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling deleteModelVersion");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models/{full_name}/versions/{version}".replace("{full_name}", ApiClient.urlEncode(fullName.toString())).replace("{version}", ApiClient.urlEncode(version.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ModelVersionInfo finalizeModelVersion(String fullName, Long version, FinalizeModelVersion finalizeModelVersion) throws ApiException {
        ApiResponse<ModelVersionInfo> localVarResponse = this.finalizeModelVersionWithHttpInfo(fullName, version, finalizeModelVersion);
        return localVarResponse.getData();
    }

    public ApiResponse<ModelVersionInfo> finalizeModelVersionWithHttpInfo(String fullName, Long version, FinalizeModelVersion finalizeModelVersion) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.finalizeModelVersionRequestBuilder(fullName, version, finalizeModelVersion);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("finalizeModelVersion", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ModelVersionInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ModelVersionInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder finalizeModelVersionRequestBuilder(String fullName, Long version, FinalizeModelVersion finalizeModelVersion) throws ApiException {
        if (fullName == null) {
            throw new ApiException(400, "Missing the required parameter 'fullName' when calling finalizeModelVersion");
        }
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling finalizeModelVersion");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models/{full_name}/versions/{version}/finalize".replace("{full_name}", ApiClient.urlEncode(fullName.toString())).replace("{version}", ApiClient.urlEncode(version.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)finalizeModelVersion);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ModelVersionInfo getModelVersion(String fullName, Long version) throws ApiException {
        ApiResponse<ModelVersionInfo> localVarResponse = this.getModelVersionWithHttpInfo(fullName, version);
        return localVarResponse.getData();
    }

    public ApiResponse<ModelVersionInfo> getModelVersionWithHttpInfo(String fullName, Long version) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getModelVersionRequestBuilder(fullName, version);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getModelVersion", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ModelVersionInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ModelVersionInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getModelVersionRequestBuilder(String fullName, Long version) throws ApiException {
        if (fullName == null) {
            throw new ApiException(400, "Missing the required parameter 'fullName' when calling getModelVersion");
        }
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling getModelVersion");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models/{full_name}/versions/{version}".replace("{full_name}", ApiClient.urlEncode(fullName.toString())).replace("{version}", ApiClient.urlEncode(version.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ListModelVersionsResponse listModelVersions(String fullName, Integer maxResults, String pageToken) throws ApiException {
        ApiResponse<ListModelVersionsResponse> localVarResponse = this.listModelVersionsWithHttpInfo(fullName, maxResults, pageToken);
        return localVarResponse.getData();
    }

    public ApiResponse<ListModelVersionsResponse> listModelVersionsWithHttpInfo(String fullName, Integer maxResults, String pageToken) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listModelVersionsRequestBuilder(fullName, maxResults, pageToken);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listModelVersions", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ListModelVersionsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ListModelVersionsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listModelVersionsRequestBuilder(String fullName, Integer maxResults, String pageToken) throws ApiException {
        if (fullName == null) {
            throw new ApiException(400, "Missing the required parameter 'fullName' when calling listModelVersions");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models/{full_name}/versions".replace("{full_name}", ApiClient.urlEncode(fullName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "max_results";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("max_results", maxResults));
        localVarQueryParameterBaseName = "page_token";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page_token", pageToken));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ModelVersionInfo updateModelVersion(String fullName, Long version, UpdateModelVersion updateModelVersion) throws ApiException {
        ApiResponse<ModelVersionInfo> localVarResponse = this.updateModelVersionWithHttpInfo(fullName, version, updateModelVersion);
        return localVarResponse.getData();
    }

    public ApiResponse<ModelVersionInfo> updateModelVersionWithHttpInfo(String fullName, Long version, UpdateModelVersion updateModelVersion) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateModelVersionRequestBuilder(fullName, version, updateModelVersion);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateModelVersion", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ModelVersionInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ModelVersionInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateModelVersionRequestBuilder(String fullName, Long version, UpdateModelVersion updateModelVersion) throws ApiException {
        if (fullName == null) {
            throw new ApiException(400, "Missing the required parameter 'fullName' when calling updateModelVersion");
        }
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling updateModelVersion");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models/{full_name}/versions/{version}".replace("{full_name}", ApiClient.urlEncode(fullName.toString())).replace("{version}", ApiClient.urlEncode(version.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateModelVersion);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

