/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.ApiException;
import io.unitycatalog.client.ApiResponse;
import io.unitycatalog.client.Pair;
import io.unitycatalog.client.model.CreateRegisteredModel;
import io.unitycatalog.client.model.ListRegisteredModelsResponse;
import io.unitycatalog.client.model.RegisteredModelInfo;
import io.unitycatalog.client.model.UpdateRegisteredModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.StringJoiner;
import java.util.function.Consumer;

public class RegisteredModelsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public RegisteredModelsApi() {
        this(new ApiClient());
    }

    public RegisteredModelsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public RegisteredModelInfo createRegisteredModel(CreateRegisteredModel createRegisteredModel) throws ApiException {
        ApiResponse<RegisteredModelInfo> localVarResponse = this.createRegisteredModelWithHttpInfo(createRegisteredModel);
        return localVarResponse.getData();
    }

    public ApiResponse<RegisteredModelInfo> createRegisteredModelWithHttpInfo(CreateRegisteredModel createRegisteredModel) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.createRegisteredModelRequestBuilder(createRegisteredModel);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("createRegisteredModel", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (RegisteredModelInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<RegisteredModelInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder createRegisteredModelRequestBuilder(CreateRegisteredModel createRegisteredModel) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)createRegisteredModel);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Object deleteRegisteredModel(String fullName, Boolean force) throws ApiException {
        ApiResponse<Object> localVarResponse = this.deleteRegisteredModelWithHttpInfo(fullName, force);
        return localVarResponse.getData();
    }

    public ApiResponse<Object> deleteRegisteredModelWithHttpInfo(String fullName, Boolean force) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.deleteRegisteredModelRequestBuilder(fullName, force);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("deleteRegisteredModel", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<Object>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder deleteRegisteredModelRequestBuilder(String fullName, Boolean force) throws ApiException {
        if (fullName == null) {
            throw new ApiException(400, "Missing the required parameter 'fullName' when calling deleteRegisteredModel");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models/{full_name}".replace("{full_name}", ApiClient.urlEncode(fullName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "force";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("force", force));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("DELETE", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public RegisteredModelInfo getRegisteredModel(String fullName) throws ApiException {
        ApiResponse<RegisteredModelInfo> localVarResponse = this.getRegisteredModelWithHttpInfo(fullName);
        return localVarResponse.getData();
    }

    public ApiResponse<RegisteredModelInfo> getRegisteredModelWithHttpInfo(String fullName) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getRegisteredModelRequestBuilder(fullName);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getRegisteredModel", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (RegisteredModelInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<RegisteredModelInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder getRegisteredModelRequestBuilder(String fullName) throws ApiException {
        if (fullName == null) {
            throw new ApiException(400, "Missing the required parameter 'fullName' when calling getRegisteredModel");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models/{full_name}".replace("{full_name}", ApiClient.urlEncode(fullName.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ListRegisteredModelsResponse listRegisteredModels(String catalogName, String schemaName, Integer maxResults, String pageToken) throws ApiException {
        ApiResponse<ListRegisteredModelsResponse> localVarResponse = this.listRegisteredModelsWithHttpInfo(catalogName, schemaName, maxResults, pageToken);
        return localVarResponse.getData();
    }

    public ApiResponse<ListRegisteredModelsResponse> listRegisteredModelsWithHttpInfo(String catalogName, String schemaName, Integer maxResults, String pageToken) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.listRegisteredModelsRequestBuilder(catalogName, schemaName, maxResults, pageToken);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("listRegisteredModels", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (ListRegisteredModelsResponse)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<ListRegisteredModelsResponse>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder listRegisteredModelsRequestBuilder(String catalogName, String schemaName, Integer maxResults, String pageToken) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "catalog_name";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("catalog_name", catalogName));
        localVarQueryParameterBaseName = "schema_name";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("schema_name", schemaName));
        localVarQueryParameterBaseName = "max_results";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("max_results", maxResults));
        localVarQueryParameterBaseName = "page_token";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page_token", pageToken));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public RegisteredModelInfo updateRegisteredModel(String fullName, UpdateRegisteredModel updateRegisteredModel) throws ApiException {
        ApiResponse<RegisteredModelInfo> localVarResponse = this.updateRegisteredModelWithHttpInfo(fullName, updateRegisteredModel);
        return localVarResponse.getData();
    }

    public ApiResponse<RegisteredModelInfo> updateRegisteredModelWithHttpInfo(String fullName, UpdateRegisteredModel updateRegisteredModel) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateRegisteredModelRequestBuilder(fullName, updateRegisteredModel);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateRegisteredModel", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (RegisteredModelInfo)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<RegisteredModelInfo>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder updateRegisteredModelRequestBuilder(String fullName, UpdateRegisteredModel updateRegisteredModel) throws ApiException {
        if (fullName == null) {
            throw new ApiException(400, "Missing the required parameter 'fullName' when calling updateRegisteredModel");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/models/{full_name}".replace("{full_name}", ApiClient.urlEncode(fullName.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)updateRegisteredModel);
            localVarRequestBuilder.method("PATCH", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

