/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.ApiException;
import io.unitycatalog.client.ApiResponse;
import io.unitycatalog.client.model.GenerateTemporaryModelVersionCredential;
import io.unitycatalog.client.model.GenerateTemporaryPathCredential;
import io.unitycatalog.client.model.GenerateTemporaryTableCredential;
import io.unitycatalog.client.model.GenerateTemporaryVolumeCredential;
import io.unitycatalog.client.model.TemporaryCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.function.Consumer;

public class TemporaryCredentialsApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public TemporaryCredentialsApi() {
        this(new ApiClient());
    }

    public TemporaryCredentialsApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public TemporaryCredentials generateTemporaryModelVersionCredentials(GenerateTemporaryModelVersionCredential generateTemporaryModelVersionCredential) throws ApiException {
        ApiResponse<TemporaryCredentials> localVarResponse = this.generateTemporaryModelVersionCredentialsWithHttpInfo(generateTemporaryModelVersionCredential);
        return localVarResponse.getData();
    }

    public ApiResponse<TemporaryCredentials> generateTemporaryModelVersionCredentialsWithHttpInfo(GenerateTemporaryModelVersionCredential generateTemporaryModelVersionCredential) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.generateTemporaryModelVersionCredentialsRequestBuilder(generateTemporaryModelVersionCredential);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("generateTemporaryModelVersionCredentials", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (TemporaryCredentials)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<TemporaryCredentials>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder generateTemporaryModelVersionCredentialsRequestBuilder(GenerateTemporaryModelVersionCredential generateTemporaryModelVersionCredential) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/temporary-model-version-credentials";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)generateTemporaryModelVersionCredential);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public TemporaryCredentials generateTemporaryPathCredentials(GenerateTemporaryPathCredential generateTemporaryPathCredential) throws ApiException {
        ApiResponse<TemporaryCredentials> localVarResponse = this.generateTemporaryPathCredentialsWithHttpInfo(generateTemporaryPathCredential);
        return localVarResponse.getData();
    }

    public ApiResponse<TemporaryCredentials> generateTemporaryPathCredentialsWithHttpInfo(GenerateTemporaryPathCredential generateTemporaryPathCredential) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.generateTemporaryPathCredentialsRequestBuilder(generateTemporaryPathCredential);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("generateTemporaryPathCredentials", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (TemporaryCredentials)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<TemporaryCredentials>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder generateTemporaryPathCredentialsRequestBuilder(GenerateTemporaryPathCredential generateTemporaryPathCredential) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/temporary-path-credentials";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)generateTemporaryPathCredential);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public TemporaryCredentials generateTemporaryTableCredentials(GenerateTemporaryTableCredential generateTemporaryTableCredential) throws ApiException {
        ApiResponse<TemporaryCredentials> localVarResponse = this.generateTemporaryTableCredentialsWithHttpInfo(generateTemporaryTableCredential);
        return localVarResponse.getData();
    }

    public ApiResponse<TemporaryCredentials> generateTemporaryTableCredentialsWithHttpInfo(GenerateTemporaryTableCredential generateTemporaryTableCredential) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.generateTemporaryTableCredentialsRequestBuilder(generateTemporaryTableCredential);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("generateTemporaryTableCredentials", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (TemporaryCredentials)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<TemporaryCredentials>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder generateTemporaryTableCredentialsRequestBuilder(GenerateTemporaryTableCredential generateTemporaryTableCredential) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/temporary-table-credentials";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)generateTemporaryTableCredential);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public TemporaryCredentials generateTemporaryVolumeCredentials(GenerateTemporaryVolumeCredential generateTemporaryVolumeCredential) throws ApiException {
        ApiResponse<TemporaryCredentials> localVarResponse = this.generateTemporaryVolumeCredentialsWithHttpInfo(generateTemporaryVolumeCredential);
        return localVarResponse.getData();
    }

    public ApiResponse<TemporaryCredentials> generateTemporaryVolumeCredentialsWithHttpInfo(GenerateTemporaryVolumeCredential generateTemporaryVolumeCredential) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.generateTemporaryVolumeCredentialsRequestBuilder(generateTemporaryVolumeCredential);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("generateTemporaryVolumeCredentials", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : (TemporaryCredentials)this.memberVarObjectMapper.readValue(localVarResponse.body(), (TypeReference)new TypeReference<TemporaryCredentials>(){})));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder generateTemporaryVolumeCredentialsRequestBuilder(GenerateTemporaryVolumeCredential generateTemporaryVolumeCredential) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/temporary-volume-credentials";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)generateTemporaryVolumeCredential);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

