/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ColumnTypeName {
    BOOLEAN("BOOLEAN"),
    BYTE("BYTE"),
    SHORT("SHORT"),
    INT("INT"),
    LONG("LONG"),
    FLOAT("FLOAT"),
    DOUBLE("DOUBLE"),
    DATE("DATE"),
    TIMESTAMP("TIMESTAMP"),
    TIMESTAMP_NTZ("TIMESTAMP_NTZ"),
    STRING("STRING"),
    BINARY("BINARY"),
    DECIMAL("DECIMAL"),
    INTERVAL("INTERVAL"),
    ARRAY("ARRAY"),
    STRUCT("STRUCT"),
    MAP("MAP"),
    CHAR("CHAR"),
    NULL("NULL"),
    USER_DEFINED_TYPE("USER_DEFINED_TYPE"),
    TABLE_TYPE("TABLE_TYPE");

    private String value;

    private ColumnTypeName(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static ColumnTypeName fromValue(String value) {
        for (ColumnTypeName b : ColumnTypeName.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

