/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.model.AwsIamRoleRequest;
import io.unitycatalog.client.model.CredentialPurpose;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "comment", "aws_iam_role", "purpose"})
public class CreateCredentialRequest {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_AWS_IAM_ROLE = "aws_iam_role";
    private AwsIamRoleRequest awsIamRole;
    public static final String JSON_PROPERTY_PURPOSE = "purpose";
    private CredentialPurpose purpose;

    public CreateCredentialRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateCredentialRequest comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public CreateCredentialRequest awsIamRole(AwsIamRoleRequest awsIamRole) {
        this.awsIamRole = awsIamRole;
        return this;
    }

    @Nullable
    @JsonProperty(value="aws_iam_role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AwsIamRoleRequest getAwsIamRole() {
        return this.awsIamRole;
    }

    @JsonProperty(value="aws_iam_role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAwsIamRole(AwsIamRoleRequest awsIamRole) {
        this.awsIamRole = awsIamRole;
    }

    public CreateCredentialRequest purpose(CredentialPurpose purpose) {
        this.purpose = purpose;
        return this;
    }

    @Nullable
    @JsonProperty(value="purpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CredentialPurpose getPurpose() {
        return this.purpose;
    }

    @JsonProperty(value="purpose")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPurpose(CredentialPurpose purpose) {
        this.purpose = purpose;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCredentialRequest createCredentialRequest = (CreateCredentialRequest)o;
        return Objects.equals(this.name, createCredentialRequest.name) && Objects.equals(this.comment, createCredentialRequest.comment) && Objects.equals(this.awsIamRole, createCredentialRequest.awsIamRole) && Objects.equals((Object)this.purpose, (Object)createCredentialRequest.purpose);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.comment, this.awsIamRole, this.purpose});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCredentialRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    awsIamRole: ").append(this.toIndentedString(this.awsIamRole)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString((Object)this.purpose)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getComment() != null) {
            joiner.add(String.format("%scomment%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getComment()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAwsIamRole() != null) {
            joiner.add(this.getAwsIamRole().toUrlQueryString((String)prefix + JSON_PROPERTY_AWS_IAM_ROLE + suffix));
        }
        if (this.getPurpose() != null) {
            joiner.add(String.format("%spurpose%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getPurpose()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

