/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.ApiClient;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "url", "credential_name", "comment"})
public class CreateExternalLocation {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_CREDENTIAL_NAME = "credential_name";
    private String credentialName;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;

    public CreateExternalLocation name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateExternalLocation url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public CreateExternalLocation credentialName(String credentialName) {
        this.credentialName = credentialName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="credential_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCredentialName() {
        return this.credentialName;
    }

    @JsonProperty(value="credential_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCredentialName(String credentialName) {
        this.credentialName = credentialName;
    }

    public CreateExternalLocation comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateExternalLocation createExternalLocation = (CreateExternalLocation)o;
        return Objects.equals(this.name, createExternalLocation.name) && Objects.equals(this.url, createExternalLocation.url) && Objects.equals(this.credentialName, createExternalLocation.credentialName) && Objects.equals(this.comment, createExternalLocation.comment);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url, this.credentialName, this.comment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateExternalLocation {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    credentialName: ").append(this.toIndentedString(this.credentialName)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUrl() != null) {
            joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCredentialName() != null) {
            joiner.add(String.format("%scredential_name%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCredentialName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getComment() != null) {
            joiner.add(String.format("%scomment%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getComment()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

