/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.model.ColumnInfo;
import io.unitycatalog.client.model.DataSourceFormat;
import io.unitycatalog.client.model.TableType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "catalog_name", "schema_name", "table_type", "data_source_format", "columns", "storage_location", "comment", "properties"})
public class CreateTable {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CATALOG_NAME = "catalog_name";
    private String catalogName;
    public static final String JSON_PROPERTY_SCHEMA_NAME = "schema_name";
    private String schemaName;
    public static final String JSON_PROPERTY_TABLE_TYPE = "table_type";
    private TableType tableType;
    public static final String JSON_PROPERTY_DATA_SOURCE_FORMAT = "data_source_format";
    private DataSourceFormat dataSourceFormat;
    public static final String JSON_PROPERTY_COLUMNS = "columns";
    private List<ColumnInfo> columns = new ArrayList<ColumnInfo>();
    public static final String JSON_PROPERTY_STORAGE_LOCATION = "storage_location";
    private String storageLocation;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, String> properties = new HashMap<String, String>();

    public CreateTable name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateTable catalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public CreateTable schemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="schema_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="schema_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public CreateTable tableType(TableType tableType) {
        this.tableType = tableType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="table_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TableType getTableType() {
        return this.tableType;
    }

    @JsonProperty(value="table_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTableType(TableType tableType) {
        this.tableType = tableType;
    }

    public CreateTable dataSourceFormat(DataSourceFormat dataSourceFormat) {
        this.dataSourceFormat = dataSourceFormat;
        return this;
    }

    @Nonnull
    @JsonProperty(value="data_source_format")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DataSourceFormat getDataSourceFormat() {
        return this.dataSourceFormat;
    }

    @JsonProperty(value="data_source_format")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDataSourceFormat(DataSourceFormat dataSourceFormat) {
        this.dataSourceFormat = dataSourceFormat;
    }

    public CreateTable columns(List<ColumnInfo> columns) {
        this.columns = columns;
        return this;
    }

    public CreateTable addColumnsItem(ColumnInfo columnsItem) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnInfo>();
        }
        this.columns.add(columnsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="columns")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setColumns(List<ColumnInfo> columns) {
        this.columns = columns;
    }

    public CreateTable storageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="storage_location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStorageLocation() {
        return this.storageLocation;
    }

    @JsonProperty(value="storage_location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public CreateTable comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public CreateTable properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public CreateTable putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTable createTable = (CreateTable)o;
        return Objects.equals(this.name, createTable.name) && Objects.equals(this.catalogName, createTable.catalogName) && Objects.equals(this.schemaName, createTable.schemaName) && Objects.equals((Object)this.tableType, (Object)createTable.tableType) && Objects.equals((Object)this.dataSourceFormat, (Object)createTable.dataSourceFormat) && Objects.equals(this.columns, createTable.columns) && Objects.equals(this.storageLocation, createTable.storageLocation) && Objects.equals(this.comment, createTable.comment) && Objects.equals(this.properties, createTable.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.catalogName, this.schemaName, this.tableType, this.dataSourceFormat, this.columns, this.storageLocation, this.comment, this.properties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTable {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    catalogName: ").append(this.toIndentedString(this.catalogName)).append("\n");
        sb.append("    schemaName: ").append(this.toIndentedString(this.schemaName)).append("\n");
        sb.append("    tableType: ").append(this.toIndentedString((Object)this.tableType)).append("\n");
        sb.append("    dataSourceFormat: ").append(this.toIndentedString((Object)this.dataSourceFormat)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    storageLocation: ").append(this.toIndentedString(this.storageLocation)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCatalogName() != null) {
            joiner.add(String.format("%scatalog_name%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCatalogName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSchemaName() != null) {
            joiner.add(String.format("%sschema_name%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSchemaName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTableType() != null) {
            joiner.add(String.format("%stable_type%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getTableType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDataSourceFormat() != null) {
            joiner.add(String.format("%sdata_source_format%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getDataSourceFormat()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getColumns() != null) {
            for (int i = 0; i < this.getColumns().size(); ++i) {
                if (this.getColumns().get(i) == null) continue;
                joiner.add(this.getColumns().get(i).toUrlQueryString(String.format("%scolumns%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getStorageLocation() != null) {
            joiner.add(String.format("%sstorage_location%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getStorageLocation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getComment() != null) {
            joiner.add(String.format("%scomment%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getComment()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getProperties() != null) {
            for (String _key : this.getProperties().keySet()) {
                joiner.add(String.format("%sproperties%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getProperties().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getProperties().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

