/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.model.VolumeType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"catalog_name", "schema_name", "name", "volume_type", "comment", "storage_location"})
public class CreateVolumeRequestContent {
    public static final String JSON_PROPERTY_CATALOG_NAME = "catalog_name";
    private String catalogName;
    public static final String JSON_PROPERTY_SCHEMA_NAME = "schema_name";
    private String schemaName;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_VOLUME_TYPE = "volume_type";
    private VolumeType volumeType;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_STORAGE_LOCATION = "storage_location";
    private String storageLocation;

    public CreateVolumeRequestContent catalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public CreateVolumeRequestContent schemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="schema_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty(value="schema_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public CreateVolumeRequestContent name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateVolumeRequestContent volumeType(VolumeType volumeType) {
        this.volumeType = volumeType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="volume_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public VolumeType getVolumeType() {
        return this.volumeType;
    }

    @JsonProperty(value="volume_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setVolumeType(VolumeType volumeType) {
        this.volumeType = volumeType;
    }

    public CreateVolumeRequestContent comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public CreateVolumeRequestContent storageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="storage_location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getStorageLocation() {
        return this.storageLocation;
    }

    @JsonProperty(value="storage_location")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateVolumeRequestContent createVolumeRequestContent = (CreateVolumeRequestContent)o;
        return Objects.equals(this.catalogName, createVolumeRequestContent.catalogName) && Objects.equals(this.schemaName, createVolumeRequestContent.schemaName) && Objects.equals(this.name, createVolumeRequestContent.name) && Objects.equals((Object)this.volumeType, (Object)createVolumeRequestContent.volumeType) && Objects.equals(this.comment, createVolumeRequestContent.comment) && Objects.equals(this.storageLocation, createVolumeRequestContent.storageLocation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.catalogName, this.schemaName, this.name, this.volumeType, this.comment, this.storageLocation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateVolumeRequestContent {\n");
        sb.append("    catalogName: ").append(this.toIndentedString(this.catalogName)).append("\n");
        sb.append("    schemaName: ").append(this.toIndentedString(this.schemaName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    volumeType: ").append(this.toIndentedString((Object)this.volumeType)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    storageLocation: ").append(this.toIndentedString(this.storageLocation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCatalogName() != null) {
            joiner.add(String.format("%scatalog_name%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCatalogName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSchemaName() != null) {
            joiner.add(String.format("%sschema_name%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSchemaName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getVolumeType() != null) {
            joiner.add(String.format("%svolume_type%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getVolumeType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getComment() != null) {
            joiner.add(String.format("%scomment%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getComment()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStorageLocation() != null) {
            joiner.add(String.format("%sstorage_location%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getStorageLocation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

