/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.model.CatalogInfo;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"catalogs", "next_page_token"})
public class ListCatalogsResponse {
    public static final String JSON_PROPERTY_CATALOGS = "catalogs";
    private List<CatalogInfo> catalogs = new ArrayList<CatalogInfo>();
    public static final String JSON_PROPERTY_NEXT_PAGE_TOKEN = "next_page_token";
    private String nextPageToken;

    public ListCatalogsResponse catalogs(List<CatalogInfo> catalogs) {
        this.catalogs = catalogs;
        return this;
    }

    public ListCatalogsResponse addCatalogsItem(CatalogInfo catalogsItem) {
        if (this.catalogs == null) {
            this.catalogs = new ArrayList<CatalogInfo>();
        }
        this.catalogs.add(catalogsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="catalogs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CatalogInfo> getCatalogs() {
        return this.catalogs;
    }

    @JsonProperty(value="catalogs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCatalogs(List<CatalogInfo> catalogs) {
        this.catalogs = catalogs;
    }

    public ListCatalogsResponse nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="next_page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    @JsonProperty(value="next_page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListCatalogsResponse listCatalogsResponse = (ListCatalogsResponse)o;
        return Objects.equals(this.catalogs, listCatalogsResponse.catalogs) && Objects.equals(this.nextPageToken, listCatalogsResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.catalogs, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListCatalogsResponse {\n");
        sb.append("    catalogs: ").append(this.toIndentedString(this.catalogs)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getCatalogs() != null) {
            for (int i = 0; i < this.getCatalogs().size(); ++i) {
                if (this.getCatalogs().get(i) == null) continue;
                joiner.add(this.getCatalogs().get(i).toUrlQueryString(String.format("%scatalogs%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getNextPageToken() != null) {
            joiner.add(String.format("%snext_page_token%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getNextPageToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

