/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.ApiClient;
import io.unitycatalog.client.model.SchemaInfo;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"schemas", "next_page_token"})
public class ListSchemasResponse {
    public static final String JSON_PROPERTY_SCHEMAS = "schemas";
    private List<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
    public static final String JSON_PROPERTY_NEXT_PAGE_TOKEN = "next_page_token";
    private String nextPageToken;

    public ListSchemasResponse schemas(List<SchemaInfo> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ListSchemasResponse addSchemasItem(SchemaInfo schemasItem) {
        if (this.schemas == null) {
            this.schemas = new ArrayList<SchemaInfo>();
        }
        this.schemas.add(schemasItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SchemaInfo> getSchemas() {
        return this.schemas;
    }

    @JsonProperty(value="schemas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemas(List<SchemaInfo> schemas) {
        this.schemas = schemas;
    }

    public ListSchemasResponse nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="next_page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    @JsonProperty(value="next_page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListSchemasResponse listSchemasResponse = (ListSchemasResponse)o;
        return Objects.equals(this.schemas, listSchemasResponse.schemas) && Objects.equals(this.nextPageToken, listSchemasResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.schemas, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListSchemasResponse {\n");
        sb.append("    schemas: ").append(this.toIndentedString(this.schemas)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSchemas() != null) {
            for (int i = 0; i < this.getSchemas().size(); ++i) {
                if (this.getSchemas().get(i) == null) continue;
                joiner.add(this.getSchemas().get(i).toUrlQueryString(String.format("%sschemas%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getNextPageToken() != null) {
            joiner.add(String.format("%snext_page_token%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getNextPageToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

