/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Privilege {
    CREATE_CATALOG("CREATE CATALOG"),
    USE_CATALOG("USE CATALOG"),
    CREATE_SCHEMA("CREATE SCHEMA"),
    USE_SCHEMA("USE SCHEMA"),
    CREATE_TABLE("CREATE TABLE"),
    SELECT("SELECT"),
    MODIFY("MODIFY"),
    CREATE_FUNCTION("CREATE FUNCTION"),
    EXECUTE("EXECUTE"),
    CREATE_VOLUME("CREATE VOLUME"),
    READ_VOLUME("READ VOLUME"),
    CREATE_MODEL("CREATE MODEL");

    private String value;

    private Privilege(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static Privilege fromValue(String value) {
        for (Privilege b : Privilege.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

