/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.client.ApiClient;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"name", "catalog_name", "comment", "properties", "full_name", "owner", "created_at", "created_by", "updated_at", "updated_by", "schema_id"})
public class SchemaInfo {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_CATALOG_NAME = "catalog_name";
    private String catalogName;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, String> properties = new HashMap<String, String>();
    public static final String JSON_PROPERTY_FULL_NAME = "full_name";
    private String fullName;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private String owner;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private Long createdAt;
    public static final String JSON_PROPERTY_CREATED_BY = "created_by";
    private String createdBy;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private Long updatedAt;
    public static final String JSON_PROPERTY_UPDATED_BY = "updated_by";
    private String updatedBy;
    public static final String JSON_PROPERTY_SCHEMA_ID = "schema_id";
    private String schemaId;

    public SchemaInfo name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SchemaInfo catalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    @Nullable
    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="catalog_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public SchemaInfo comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public SchemaInfo properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public SchemaInfo putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public SchemaInfo fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Nullable
    @JsonProperty(value="full_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="full_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public SchemaInfo owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwner(String owner) {
        this.owner = owner;
    }

    public SchemaInfo createdAt(Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public SchemaInfo createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="created_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public SchemaInfo updatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public SchemaInfo updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Nullable
    @JsonProperty(value="updated_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @JsonProperty(value="updated_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public SchemaInfo schemaId(String schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    @Nullable
    @JsonProperty(value="schema_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchemaId() {
        return this.schemaId;
    }

    @JsonProperty(value="schema_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaInfo schemaInfo = (SchemaInfo)o;
        return Objects.equals(this.name, schemaInfo.name) && Objects.equals(this.catalogName, schemaInfo.catalogName) && Objects.equals(this.comment, schemaInfo.comment) && Objects.equals(this.properties, schemaInfo.properties) && Objects.equals(this.fullName, schemaInfo.fullName) && Objects.equals(this.owner, schemaInfo.owner) && Objects.equals(this.createdAt, schemaInfo.createdAt) && Objects.equals(this.createdBy, schemaInfo.createdBy) && Objects.equals(this.updatedAt, schemaInfo.updatedAt) && Objects.equals(this.updatedBy, schemaInfo.updatedBy) && Objects.equals(this.schemaId, schemaInfo.schemaId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.catalogName, this.comment, this.properties, this.fullName, this.owner, this.createdAt, this.createdBy, this.updatedAt, this.updatedBy, this.schemaId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchemaInfo {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    catalogName: ").append(this.toIndentedString(this.catalogName)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString(this.updatedBy)).append("\n");
        sb.append("    schemaId: ").append(this.toIndentedString(this.schemaId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCatalogName() != null) {
            joiner.add(String.format("%scatalog_name%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCatalogName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getComment() != null) {
            joiner.add(String.format("%scomment%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getComment()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getProperties() != null) {
            for (String _key : this.getProperties().keySet()) {
                joiner.add(String.format("%sproperties%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getProperties().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getProperties().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getFullName() != null) {
            joiner.add(String.format("%sfull_name%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getFullName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getOwner() != null) {
            joiner.add(String.format("%sowner%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getOwner()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCreatedAt() != null) {
            joiner.add(String.format("%screated_at%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCreatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCreatedBy() != null) {
            joiner.add(String.format("%screated_by%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCreatedBy()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUpdatedAt() != null) {
            joiner.add(String.format("%supdated_at%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getUpdatedAt()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUpdatedBy() != null) {
            joiner.add(String.format("%supdated_by%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getUpdatedBy()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSchemaId() != null) {
            joiner.add(String.format("%sschema_id%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSchemaId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

