/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SecurableType {
    METASTORE("metastore"),
    CATALOG("catalog"),
    SCHEMA("schema"),
    TABLE("table"),
    FUNCTION("function"),
    VOLUME("volume"),
    REGISTERED_MODEL("registered_model");

    private String value;

    private SecurableType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SecurableType fromValue(String value) {
        for (SecurableType b : SecurableType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

