/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TableType {
    MANAGED("MANAGED"),
    EXTERNAL("EXTERNAL");

    private String value;

    private TableType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static TableType fromValue(String value) {
        for (TableType b : TableType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

