/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.control.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.control.model.AccessTokenType;
import io.unitycatalog.control.model.TokenType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"access_token", "issued_token_type", "token_type", "expires_in", "scope", "refresh_token"})
public class OAuthTokenExchangeInfo {
    public static final String JSON_PROPERTY_ACCESS_TOKEN = "access_token";
    private String accessToken;
    public static final String JSON_PROPERTY_ISSUED_TOKEN_TYPE = "issued_token_type";
    private TokenType issuedTokenType;
    public static final String JSON_PROPERTY_TOKEN_TYPE = "token_type";
    private AccessTokenType tokenType;
    public static final String JSON_PROPERTY_EXPIRES_IN = "expires_in";
    private Long expiresIn;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private String refreshToken;

    public OAuthTokenExchangeInfo accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nonnull
    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuthTokenExchangeInfo issuedTokenType(TokenType issuedTokenType) {
        this.issuedTokenType = issuedTokenType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="issued_token_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TokenType getIssuedTokenType() {
        return this.issuedTokenType;
    }

    @JsonProperty(value="issued_token_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuedTokenType(TokenType issuedTokenType) {
        this.issuedTokenType = issuedTokenType;
    }

    public OAuthTokenExchangeInfo tokenType(AccessTokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="token_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AccessTokenType getTokenType() {
        return this.tokenType;
    }

    @JsonProperty(value="token_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTokenType(AccessTokenType tokenType) {
        this.tokenType = tokenType;
    }

    public OAuthTokenExchangeInfo expiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public OAuthTokenExchangeInfo scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public OAuthTokenExchangeInfo refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthTokenExchangeInfo oauthTokenExchangeInfo = (OAuthTokenExchangeInfo)o;
        return Objects.equals(this.accessToken, oauthTokenExchangeInfo.accessToken) && Objects.equals((Object)this.issuedTokenType, (Object)oauthTokenExchangeInfo.issuedTokenType) && Objects.equals((Object)this.tokenType, (Object)oauthTokenExchangeInfo.tokenType) && Objects.equals(this.expiresIn, oauthTokenExchangeInfo.expiresIn) && Objects.equals(this.scope, oauthTokenExchangeInfo.scope) && Objects.equals(this.refreshToken, oauthTokenExchangeInfo.refreshToken);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessToken, this.issuedTokenType, this.tokenType, this.expiresIn, this.scope, this.refreshToken});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthTokenExchangeInfo {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    issuedTokenType: ").append(this.toIndentedString((Object)this.issuedTokenType)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

