/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class URLTranscoderVerticle
extends AbstractVerticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLTranscoderVerticle.class);
    private final int transcodePort;
    private final int servicePort;

    URLTranscoderVerticle(int transcodePort, int servicePort) {
        this.transcodePort = transcodePort;
        this.servicePort = servicePort;
    }

    public void start() {
        HttpServer server = this.vertx.createHttpServer();
        WebClient client = WebClient.create((Vertx)this.vertx);
        server.requestHandler(transcodeRequest -> transcodeRequest.body().compose(buffer -> {
            HttpMethod method = transcodeRequest.method();
            String host = "127.0.0.1";
            String path = transcodeRequest.path().replace("%1F", ".");
            HttpRequest serviceRequest = client.request(method, this.servicePort, host, path);
            serviceRequest.putHeaders(transcodeRequest.headers());
            for (Map.Entry entry : transcodeRequest.params()) {
                serviceRequest.addQueryParam((String)entry.getKey(), ((String)entry.getValue()).replace('\u001f', '.'));
            }
            return serviceRequest.sendBuffer(buffer);
        }).compose(resp -> {
            HttpServerResponse transcodeResp = transcodeRequest.response();
            transcodeResp.setStatusCode(resp.statusCode());
            for (Map.Entry entry : resp.headers()) {
                transcodeResp.putHeader((String)entry.getKey(), (String)entry.getValue());
            }
            return transcodeResp.end(resp.bodyAsBuffer());
        }));
        server.listen(this.transcodePort, ar -> {
            if (ar.succeeded()) {
                LOGGER.info("URL transcoder started on port {}", (Object)this.transcodePort);
            } else {
                LOGGER.info("Failed to start URL transcoder: {}", (Object)String.valueOf(ar.cause()));
            }
        });
    }
}

