/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.annotation.JacksonRequestConverterFunction;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.docs.DocService;
import io.unitycatalog.server.URLTranscoderVerticle;
import io.unitycatalog.server.auth.AllowingAuthorizer;
import io.unitycatalog.server.auth.JCasbinAuthorizer;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.auth.decorator.UnityAccessDecorator;
import io.unitycatalog.server.auth.decorator.UnityAccessUtil;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.exception.ExceptionHandlingDecorator;
import io.unitycatalog.server.exception.GlobalExceptionHandler;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.utils.HibernateConfigurator;
import io.unitycatalog.server.security.SecurityConfiguration;
import io.unitycatalog.server.security.SecurityContext;
import io.unitycatalog.server.service.AuthDecorator;
import io.unitycatalog.server.service.AuthService;
import io.unitycatalog.server.service.CatalogService;
import io.unitycatalog.server.service.CredentialService;
import io.unitycatalog.server.service.ExternalLocationService;
import io.unitycatalog.server.service.FunctionService;
import io.unitycatalog.server.service.IcebergRestCatalogService;
import io.unitycatalog.server.service.MetastoreService;
import io.unitycatalog.server.service.ModelService;
import io.unitycatalog.server.service.PermissionService;
import io.unitycatalog.server.service.SchemaService;
import io.unitycatalog.server.service.Scim2SelfService;
import io.unitycatalog.server.service.Scim2UserService;
import io.unitycatalog.server.service.TableService;
import io.unitycatalog.server.service.TemporaryModelVersionCredentialsService;
import io.unitycatalog.server.service.TemporaryPathCredentialsService;
import io.unitycatalog.server.service.TemporaryTableCredentialsService;
import io.unitycatalog.server.service.TemporaryVolumeCredentialsService;
import io.unitycatalog.server.service.VolumeService;
import io.unitycatalog.server.service.credential.CloudCredentialVendor;
import io.unitycatalog.server.service.credential.aws.AwsCredentialVendor;
import io.unitycatalog.server.service.credential.azure.AzureCredentialVendor;
import io.unitycatalog.server.service.credential.gcp.GcpCredentialVendor;
import io.unitycatalog.server.service.iceberg.FileIOFactory;
import io.unitycatalog.server.service.iceberg.MetadataService;
import io.unitycatalog.server.service.iceberg.TableConfigService;
import io.unitycatalog.server.utils.OptionParser;
import io.unitycatalog.server.utils.RESTObjectMapper;
import io.unitycatalog.server.utils.ServerProperties;
import io.unitycatalog.server.utils.VersionUtils;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import java.nio.file.Path;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnityCatalogServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnityCatalogServer.class);
    private static final String BASE_PATH = "/api/2.1/unity-catalog/";
    private static final String CONTROL_PATH = "/api/1.0/unity-control/";
    private static final int DEFAULT_PORT = 8080;
    public static final String SERVER_PROPERTIES_FILE = "etc/conf/server.properties";
    private final Server server;
    private final ServerProperties serverProperties;
    private final SecurityContext securityContext;

    public UnityCatalogServer() {
        this(UnityCatalogServer.builder());
    }

    private UnityCatalogServer(Builder unityCatalogServerBuilder) {
        this.setDefaults(unityCatalogServerBuilder);
        Path configurationFolder = Path.of("etc", "conf");
        SecurityConfiguration securityConfiguration = new SecurityConfiguration(configurationFolder);
        this.securityContext = new SecurityContext(configurationFolder, securityConfiguration, "server", "internal");
        this.serverProperties = unityCatalogServerBuilder.serverProperties;
        this.server = this.initializeServer(unityCatalogServerBuilder);
    }

    private void setDefaults(Builder unityCatalogServerBuilder) {
        if (unityCatalogServerBuilder.port == 0) {
            unityCatalogServerBuilder.port(8080);
        }
        if (unityCatalogServerBuilder.serverProperties == null) {
            unityCatalogServerBuilder.serverProperties(new ServerProperties(SERVER_PROPERTIES_FILE));
        }
        if (unityCatalogServerBuilder.cloudCredentialVendor == null) {
            AwsCredentialVendor awsCredentialVendor = new AwsCredentialVendor(unityCatalogServerBuilder.serverProperties);
            AzureCredentialVendor azureCredentialVendor = new AzureCredentialVendor(unityCatalogServerBuilder.serverProperties);
            GcpCredentialVendor gcpCredentialVendor = new GcpCredentialVendor(unityCatalogServerBuilder.serverProperties);
            CloudCredentialVendor cloudCredentialVendor = new CloudCredentialVendor(awsCredentialVendor, azureCredentialVendor, gcpCredentialVendor);
            unityCatalogServerBuilder.credentialOperations(cloudCredentialVendor);
        }
    }

    private Server initializeServer(Builder unityCatalogServerBuilder) {
        ServerBuilder armeriaServerBuilder = Server.builder().http(unityCatalogServerBuilder.port).serviceUnder("/docs", (HttpService)new DocService());
        HibernateConfigurator hibernateConfigurator = new HibernateConfigurator(unityCatalogServerBuilder.serverProperties);
        Repositories repositories = new Repositories(hibernateConfigurator.getSessionFactory(), this.serverProperties);
        repositories.getMetastoreRepository().initMetastoreIfNeeded();
        UnityCatalogAuthorizer authorizer = this.initializeAuthorizer(unityCatalogServerBuilder.serverProperties, hibernateConfigurator, repositories);
        this.addApiServices(armeriaServerBuilder, unityCatalogServerBuilder, authorizer, repositories);
        this.addSecurityDecorators(armeriaServerBuilder, unityCatalogServerBuilder.serverProperties, authorizer, repositories);
        return armeriaServerBuilder.build();
    }

    private UnityCatalogAuthorizer initializeAuthorizer(ServerProperties serverProperties, HibernateConfigurator hibernateConfigurator, Repositories repositories) {
        if (serverProperties.isAuthorizationEnabled()) {
            try {
                LOGGER.info("Initializing JCasbinAuthorizer...");
                JCasbinAuthorizer authorizer = new JCasbinAuthorizer(hibernateConfigurator);
                new UnityAccessUtil(repositories).initializeAdmin(authorizer);
                return authorizer;
            }
            catch (Exception e) {
                throw new BaseException(ErrorCode.INTERNAL, "Problem initializing authorizer.");
            }
        }
        LOGGER.info("Authorization disabled. Using AllowingAuthorizer.");
        return new AllowingAuthorizer();
    }

    private void addApiServices(ServerBuilder armeriaServerBuilder, Builder unityCatalogServerBuilder, UnityCatalogAuthorizer authorizer, Repositories repositories) {
        LOGGER.info("Adding Unity Catalog API services...");
        CloudCredentialVendor cloudCredentialVendor = unityCatalogServerBuilder.cloudCredentialVendor;
        AuthService authService = new AuthService(this.securityContext, unityCatalogServerBuilder.serverProperties, repositories);
        PermissionService permissionService = new PermissionService(authorizer, repositories);
        Scim2UserService scim2UserService = new Scim2UserService(authorizer, repositories);
        Scim2SelfService scim2SelfService = new Scim2SelfService(authorizer, repositories);
        CatalogService catalogService = new CatalogService(authorizer, repositories);
        SchemaService schemaService = new SchemaService(authorizer, repositories);
        VolumeService volumeService = new VolumeService(authorizer, repositories);
        TableService tableService = new TableService(authorizer, repositories);
        FunctionService functionService = new FunctionService(authorizer, repositories);
        ModelService modelService = new ModelService(authorizer, repositories);
        CredentialService credentialService = new CredentialService(authorizer, repositories);
        ExternalLocationService externalLocationService = new ExternalLocationService(authorizer, repositories);
        MetastoreService metastoreService = new MetastoreService(repositories);
        TemporaryTableCredentialsService temporaryTableCredentialsService = new TemporaryTableCredentialsService(authorizer, cloudCredentialVendor, repositories);
        TemporaryVolumeCredentialsService temporaryVolumeCredentialsService = new TemporaryVolumeCredentialsService(authorizer, cloudCredentialVendor, repositories);
        TemporaryModelVersionCredentialsService temporaryModelVersionCredentialsService = new TemporaryModelVersionCredentialsService(authorizer, cloudCredentialVendor, repositories);
        TemporaryPathCredentialsService temporaryPathCredentialsService = new TemporaryPathCredentialsService(cloudCredentialVendor);
        JacksonRequestConverterFunction requestConverterFunction = new JacksonRequestConverterFunction(((JsonMapper.Builder)JsonMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build());
        JacksonResponseConverterFunction scimResponseConverterFunction = new JacksonResponseConverterFunction(((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).serializationInclusion(JsonInclude.Include.NON_NULL)).build());
        armeriaServerBuilder.service("/", (ctx, req) -> HttpResponse.of((String)"Hello, Unity Catalog!")).annotatedService("/api/1.0/unity-control/auth", (Object)authService, new Object[]{requestConverterFunction}).annotatedService("/api/1.0/unity-control/scim2/Users", (Object)scim2UserService, new Object[]{requestConverterFunction, scimResponseConverterFunction}).annotatedService("/api/1.0/unity-control/scim2/Me", (Object)scim2SelfService, new Object[]{requestConverterFunction, scimResponseConverterFunction}).annotatedService("/api/2.1/unity-catalog/permissions", (Object)permissionService).annotatedService("/api/2.1/unity-catalog/catalogs", (Object)catalogService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/schemas", (Object)schemaService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/volumes", (Object)volumeService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/tables", (Object)tableService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/functions", (Object)functionService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/models", (Object)modelService, new Object[]{requestConverterFunction}).annotatedService(BASE_PATH, (Object)metastoreService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/temporary-table-credentials", (Object)temporaryTableCredentialsService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/temporary-volume-credentials", (Object)temporaryVolumeCredentialsService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/temporary-model-version-credentials", (Object)temporaryModelVersionCredentialsService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/temporary-path-credentials", (Object)temporaryPathCredentialsService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/credentials", (Object)credentialService, new Object[]{requestConverterFunction}).annotatedService("/api/2.1/unity-catalog/external-locations", (Object)externalLocationService, new Object[]{requestConverterFunction});
        this.addIcebergApiServices(armeriaServerBuilder, unityCatalogServerBuilder.serverProperties, unityCatalogServerBuilder.cloudCredentialVendor, catalogService, schemaService, tableService, repositories);
    }

    private void addIcebergApiServices(ServerBuilder armeriaServerBuilder, ServerProperties serverProperties, CloudCredentialVendor cloudCredentialVendor, CatalogService catalogService, SchemaService schemaService, TableService tableService, Repositories repositories) {
        LOGGER.info("Adding Iceberg services...");
        ObjectMapper icebergMapper = RESTObjectMapper.mapper();
        JacksonRequestConverterFunction icebergRequestConverter = new JacksonRequestConverterFunction(icebergMapper);
        JacksonResponseConverterFunction icebergResponseConverter = new JacksonResponseConverterFunction(icebergMapper);
        MetadataService metadataService = new MetadataService(new FileIOFactory(cloudCredentialVendor, serverProperties));
        TableConfigService tableConfigService = new TableConfigService(cloudCredentialVendor, serverProperties);
        armeriaServerBuilder.annotatedService("/api/2.1/unity-catalog/iceberg", (Object)new IcebergRestCatalogService(catalogService, schemaService, tableService, tableConfigService, metadataService, repositories), new Object[]{icebergRequestConverter, icebergResponseConverter});
    }

    private void addSecurityDecorators(ServerBuilder armeriaServerBuilder, ServerProperties serverProperties, UnityCatalogAuthorizer authorizer, Repositories repositories) {
        if (serverProperties.isAuthorizationEnabled()) {
            LOGGER.info("Enabling security decorators...");
            UnityAccessDecorator accessDecorator = new UnityAccessDecorator(authorizer, repositories);
            armeriaServerBuilder.routeDecorator().pathPrefix(BASE_PATH).build((DecoratingHttpServiceFunction)accessDecorator);
            armeriaServerBuilder.routeDecorator().pathPrefix(CONTROL_PATH).exclude("/api/1.0/unity-control/auth/tokens").build((DecoratingHttpServiceFunction)accessDecorator);
            AuthDecorator authDecorator = new AuthDecorator(this.securityContext, repositories);
            armeriaServerBuilder.routeDecorator().pathPrefix(BASE_PATH).build((DecoratingHttpServiceFunction)authDecorator);
            armeriaServerBuilder.routeDecorator().pathPrefix(CONTROL_PATH).exclude("/api/1.0/unity-control/auth/tokens").build((DecoratingHttpServiceFunction)authDecorator);
            ExceptionHandlingDecorator exceptionDecorator = new ExceptionHandlingDecorator(new GlobalExceptionHandler());
            armeriaServerBuilder.decorator((DecoratingHttpServiceFunction)exceptionDecorator);
        }
    }

    public static void main(String[] args) {
        OptionParser options = new OptionParser();
        options.parse(args);
        UnityCatalogServer unityCatalogServer = UnityCatalogServer.builder().port(options.getPort() + 1).build();
        unityCatalogServer.printArt();
        unityCatalogServer.start();
        Vertx vertx = Vertx.vertx();
        URLTranscoderVerticle transcodeVerticle = new URLTranscoderVerticle(options.getPort(), options.getPort() + 1);
        vertx.deployVerticle((Verticle)transcodeVerticle);
    }

    public void start() {
        LOGGER.info("Starting Unity Catalog server...");
        this.server.start().join();
        LOGGER.info("Unity Catalog server started.");
    }

    public void stop() {
        this.server.stop().join();
        LOGGER.info("Unity Catalog server stopped.");
    }

    private void printArt() {
        String art = "################################################################### \n#  _    _       _ _            _____      _        _              #\n# | |  | |     (_) |          / ____|    | |      | |             #\n# | |  | |_ __  _| |_ _   _  | |     __ _| |_ __ _| | ___   __ _  #\n# | |  | | '_ \\| | __| | | | | |    / _` | __/ _` | |/ _ \\ / _` | #\n# | |__| | | | | | |_| |_| | | |___| (_| | || (_| | | (_) | (_| | #\n#  \\____/|_| |_|_|\\__|\\__, |  \\_____\\__,_|\\__\\__,_|_|\\___/ \\__, | #\n#                      __/ |                                __/ | #\n#                     |___/               " + String.format("%15s", "v" + VersionUtils.VERSION) + "  |___/  #\n###################################################################\n";
        System.out.println(art);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        System.setProperty("log4j.configurationFile", "etc/conf/server.log4j2.properties");
        Configurator.initialize(null, (String)"etc/conf/server.log4j2.properties");
    }

    public static class Builder {
        private int port;
        private ServerProperties serverProperties;
        private CloudCredentialVendor cloudCredentialVendor;

        private Builder() {
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder serverProperties(ServerProperties serverProperties) {
            this.serverProperties = serverProperties;
            return this;
        }

        public Builder credentialOperations(CloudCredentialVendor cloudCredentialVendor) {
            this.cloudCredentialVendor = cloudCredentialVendor;
            return this;
        }

        public UnityCatalogServer build() {
            return new UnityCatalogServer(this);
        }
    }
}

