/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.auth;

import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.persist.model.Privileges;
import io.unitycatalog.server.persist.utils.HibernateConfigurator;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.casbin.adapter.JDBCAdapter;
import org.casbin.jcasbin.main.Enforcer;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;

public class JCasbinAuthorizer
implements UnityCatalogAuthorizer {
    private final Enforcer enforcer;
    private static final int PRINCIPAL_INDEX = 0;
    private static final int RESOURCE_INDEX = 1;
    private static final int PRIVILEGE_INDEX = 2;
    private static final String HIERARCHY_POLICY = "g2";
    private static final int HIERARCHY_PARENT_INDEX = 0;
    private static final int HIERARCHY_CHILD_INDEX = 1;

    public JCasbinAuthorizer(HibernateConfigurator hibernateConfigurator) throws Exception {
        Properties properties = hibernateConfigurator.getHibernateProperties();
        String driver = properties.getProperty("hibernate.connection.driver_class");
        String url = properties.getProperty("hibernate.connection.url");
        String user = properties.getProperty("hibernate.connection.user");
        String password = properties.getProperty("hibernate.connection.password");
        JDBCAdapter adapter = new JDBCAdapter(driver, url, user, password);
        InputStream modelStream = this.getClass().getResourceAsStream("/jcasbin_auth_model.conf");
        String string = IOUtils.toString((InputStream)modelStream, (Charset)StandardCharsets.UTF_8);
        Model model = new Model();
        model.loadModelFromText(string);
        this.enforcer = new Enforcer(model, (Adapter)adapter);
        this.enforcer.enableAutoSave(true);
    }

    @Override
    public boolean grantAuthorization(UUID principal, UUID resource, Privileges action) {
        return this.enforcer.addPolicy(new String[]{principal.toString(), resource.toString(), action.toString()});
    }

    @Override
    public boolean revokeAuthorization(UUID principal, UUID resource, Privileges action) {
        return this.enforcer.removePolicy(new String[]{principal.toString(), resource.toString(), action.toString()});
    }

    @Override
    public boolean clearAuthorizationsForPrincipal(UUID principal) {
        return this.enforcer.removeFilteredPolicy(0, new String[]{principal.toString()});
    }

    @Override
    public boolean clearAuthorizationsForResource(UUID resource) {
        return this.enforcer.removeFilteredPolicy(1, new String[]{resource.toString()});
    }

    @Override
    public boolean addHierarchyChild(UUID parent, UUID child) {
        return this.enforcer.addNamedGroupingPolicy(HIERARCHY_POLICY, new String[]{parent.toString(), child.toString()});
    }

    @Override
    public boolean removeHierarchyChild(UUID parent, UUID child) {
        return this.enforcer.removeNamedGroupingPolicy(HIERARCHY_POLICY, new String[]{parent.toString(), child.toString()});
    }

    @Override
    public boolean removeHierarchyChildren(UUID resource) {
        return this.enforcer.removeFilteredNamedGroupingPolicy(HIERARCHY_POLICY, 0, new String[]{resource.toString()});
    }

    @Override
    public UUID getHierarchyParent(UUID resource) {
        List policy = this.enforcer.getFilteredNamedGroupingPolicy(HIERARCHY_POLICY, 1, new String[]{resource.toString()});
        if (policy.isEmpty() || ((List)policy.get(0)).isEmpty()) {
            return null;
        }
        return UUID.fromString((String)((List)policy.get(0)).get(0));
    }

    @Override
    public boolean authorize(UUID principal, UUID resource, Privileges action) {
        return this.enforcer.enforce(new Object[]{principal.toString(), resource.toString(), action.toString()});
    }

    @Override
    public boolean authorizeAny(UUID principal, UUID resource, Privileges ... actions) {
        return Arrays.stream(actions).anyMatch(action -> this.enforcer.enforce(new Object[]{principal.toString(), resource.toString(), action.toString()}));
    }

    @Override
    public boolean authorizeAll(UUID principal, UUID resource, Privileges ... actions) {
        return Arrays.stream(actions).allMatch(action -> this.enforcer.enforce(new Object[]{principal.toString(), resource.toString(), action.toString()}));
    }

    @Override
    public List<Privileges> listAuthorizations(UUID principal, UUID resource) {
        List list = this.enforcer.getPermissionsForUserInDomain(principal.toString(), resource.toString());
        return list.stream().map(l -> (String)l.get(2)).map(Privileges::fromValue).collect(Collectors.toList());
    }

    @Override
    public Map<UUID, List<Privileges>> listAuthorizations(UUID resource) {
        return this.enforcer.getFilteredPolicy(1, new String[]{resource.toString()}).stream().collect(Collectors.groupingBy(l -> UUID.fromString((String)l.get(0)), Collectors.mapping(l -> Privileges.fromValue((String)l.get(2)), Collectors.toList())));
    }
}

