/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.auth.decorator;

import io.unitycatalog.server.model.SecurableType;

public class KeyLocator {
    private SecurableType type;
    private Source source;
    private String key;

    KeyLocator(SecurableType type, Source source, String key) {
        this.type = type;
        this.source = source;
        this.key = key;
    }

    public static KeyLocatorBuilder builder() {
        return new KeyLocatorBuilder();
    }

    public SecurableType getType() {
        return this.type;
    }

    public Source getSource() {
        return this.source;
    }

    public String getKey() {
        return this.key;
    }

    public static enum Source {
        SYSTEM,
        PARAM,
        PAYLOAD;

    }

    public static class KeyLocatorBuilder {
        private SecurableType type;
        private Source source;
        private String key;

        KeyLocatorBuilder() {
        }

        public KeyLocatorBuilder type(SecurableType type) {
            this.type = type;
            return this;
        }

        public KeyLocatorBuilder source(Source source) {
            this.source = source;
            return this;
        }

        public KeyLocatorBuilder key(String key) {
            this.key = key;
            return this;
        }

        public KeyLocator build() {
            return new KeyLocator(this.type, this.source, this.key);
        }

        public String toString() {
            return "KeyLocator.KeyLocatorBuilder(type=" + String.valueOf((Object)this.type) + ", source=" + String.valueOf((Object)this.source) + ", key=" + this.key + ")";
        }
    }
}

