/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.auth.decorator;

import io.unitycatalog.server.model.CatalogInfo;
import io.unitycatalog.server.model.FunctionInfo;
import io.unitycatalog.server.model.RegisteredModelInfo;
import io.unitycatalog.server.model.SchemaInfo;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.model.TableInfo;
import io.unitycatalog.server.model.VolumeInfo;
import io.unitycatalog.server.persist.CatalogRepository;
import io.unitycatalog.server.persist.FunctionRepository;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.ModelRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.SchemaRepository;
import io.unitycatalog.server.persist.TableRepository;
import io.unitycatalog.server.persist.VolumeRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class KeyMapper {
    private final CatalogRepository catalogRepository;
    private final SchemaRepository schemaRepository;
    private final TableRepository tableRepository;
    private final VolumeRepository volumeRepository;
    private final FunctionRepository functionRepository;
    private final ModelRepository modelRepository;
    private final MetastoreRepository metastoreRepository;

    public KeyMapper(Repositories repositories) {
        this.catalogRepository = repositories.getCatalogRepository();
        this.schemaRepository = repositories.getSchemaRepository();
        this.tableRepository = repositories.getTableRepository();
        this.volumeRepository = repositories.getVolumeRepository();
        this.functionRepository = repositories.getFunctionRepository();
        this.modelRepository = repositories.getModelRepository();
        this.metastoreRepository = repositories.getMetastoreRepository();
    }

    public Map<SecurableType, Object> mapResourceKeys(Map<SecurableType, Object> resourceKeys) {
        SchemaInfo schema;
        RegisteredModelInfo model;
        FunctionInfo function;
        VolumeInfo volume;
        CatalogInfo catalog;
        SchemaInfo schema2;
        String fullSchemaName;
        TableInfo table;
        Object fullName;
        HashMap<SecurableType, Object> resourceIds = new HashMap<SecurableType, Object>();
        if (resourceKeys.containsKey((Object)SecurableType.CATALOG) && resourceKeys.containsKey((Object)SecurableType.SCHEMA) && resourceKeys.containsKey((Object)SecurableType.TABLE)) {
            fullName = String.valueOf(resourceKeys.get((Object)SecurableType.CATALOG)) + "." + String.valueOf(resourceKeys.get((Object)SecurableType.SCHEMA)) + "." + String.valueOf(resourceKeys.get((Object)SecurableType.TABLE));
            table = this.tableRepository.getTable((String)fullName);
            resourceIds.put(SecurableType.TABLE, UUID.fromString(table.getTableId()));
        }
        if (!resourceKeys.containsKey((Object)SecurableType.CATALOG) && !resourceKeys.containsKey((Object)SecurableType.SCHEMA) && resourceKeys.containsKey((Object)SecurableType.TABLE)) {
            fullName = (String)resourceKeys.get((Object)SecurableType.TABLE);
            table = ((String)fullName).contains(".") ? this.tableRepository.getTable((String)fullName) : this.tableRepository.getTableById((String)fullName);
            fullSchemaName = table.getCatalogName() + "." + table.getSchemaName();
            schema2 = this.schemaRepository.getSchema(fullSchemaName);
            catalog = this.catalogRepository.getCatalog(table.getCatalogName());
            resourceIds.put(SecurableType.TABLE, UUID.fromString(table.getTableId()));
            resourceIds.put(SecurableType.SCHEMA, UUID.fromString(schema2.getSchemaId()));
            resourceIds.put(SecurableType.CATALOG, UUID.fromString(catalog.getId()));
        }
        if (resourceKeys.containsKey((Object)SecurableType.CATALOG) && resourceKeys.containsKey((Object)SecurableType.SCHEMA) && resourceKeys.containsKey((Object)SecurableType.VOLUME)) {
            fullName = String.valueOf(resourceKeys.get((Object)SecurableType.CATALOG)) + "." + String.valueOf(resourceKeys.get((Object)SecurableType.SCHEMA)) + "." + String.valueOf(resourceKeys.get((Object)SecurableType.VOLUME));
            volume = this.volumeRepository.getVolume((String)fullName);
            resourceIds.put(SecurableType.VOLUME, UUID.fromString(volume.getVolumeId()));
        }
        if (!resourceKeys.containsKey((Object)SecurableType.CATALOG) && !resourceKeys.containsKey((Object)SecurableType.SCHEMA) && resourceKeys.containsKey((Object)SecurableType.VOLUME)) {
            fullName = (String)resourceKeys.get((Object)SecurableType.VOLUME);
            volume = ((String)fullName).contains(".") ? this.volumeRepository.getVolume((String)fullName) : this.volumeRepository.getVolumeById((String)fullName);
            fullSchemaName = volume.getCatalogName() + "." + volume.getSchemaName();
            schema2 = this.schemaRepository.getSchema(fullSchemaName);
            catalog = this.catalogRepository.getCatalog(volume.getCatalogName());
            resourceIds.put(SecurableType.VOLUME, UUID.fromString(volume.getVolumeId()));
            resourceIds.put(SecurableType.SCHEMA, UUID.fromString(schema2.getSchemaId()));
            resourceIds.put(SecurableType.CATALOG, UUID.fromString(catalog.getId()));
        }
        if (resourceKeys.containsKey((Object)SecurableType.CATALOG) && resourceKeys.containsKey((Object)SecurableType.SCHEMA) && resourceKeys.containsKey((Object)SecurableType.FUNCTION)) {
            fullName = String.valueOf(resourceKeys.get((Object)SecurableType.CATALOG)) + "." + String.valueOf(resourceKeys.get((Object)SecurableType.SCHEMA)) + "." + String.valueOf(resourceKeys.get((Object)SecurableType.FUNCTION));
            function = this.functionRepository.getFunction((String)fullName);
            resourceIds.put(SecurableType.FUNCTION, UUID.fromString(function.getFunctionId()));
        }
        if (!resourceKeys.containsKey((Object)SecurableType.CATALOG) && !resourceKeys.containsKey((Object)SecurableType.SCHEMA) && resourceKeys.containsKey((Object)SecurableType.FUNCTION)) {
            fullName = (String)resourceKeys.get((Object)SecurableType.FUNCTION);
            function = this.functionRepository.getFunction((String)fullName);
            fullSchemaName = function.getCatalogName() + "." + function.getSchemaName();
            schema2 = this.schemaRepository.getSchema(fullSchemaName);
            catalog = this.catalogRepository.getCatalog(function.getCatalogName());
            resourceIds.put(SecurableType.FUNCTION, UUID.fromString(function.getFunctionId()));
            resourceIds.put(SecurableType.SCHEMA, UUID.fromString(schema2.getSchemaId()));
            resourceIds.put(SecurableType.CATALOG, UUID.fromString(catalog.getId()));
        }
        if (resourceKeys.containsKey((Object)SecurableType.CATALOG) && resourceKeys.containsKey((Object)SecurableType.SCHEMA) && resourceKeys.containsKey((Object)SecurableType.REGISTERED_MODEL)) {
            fullName = String.valueOf(resourceKeys.get((Object)SecurableType.CATALOG)) + "." + String.valueOf(resourceKeys.get((Object)SecurableType.SCHEMA)) + "." + String.valueOf(resourceKeys.get((Object)SecurableType.REGISTERED_MODEL));
            model = this.modelRepository.getRegisteredModel((String)fullName);
            resourceIds.put(SecurableType.REGISTERED_MODEL, UUID.fromString(model.getId()));
        }
        if (!resourceKeys.containsKey((Object)SecurableType.CATALOG) && !resourceKeys.containsKey((Object)SecurableType.SCHEMA) && resourceKeys.containsKey((Object)SecurableType.REGISTERED_MODEL)) {
            fullName = (String)resourceKeys.get((Object)SecurableType.REGISTERED_MODEL);
            model = this.modelRepository.getRegisteredModel((String)fullName);
            fullSchemaName = model.getCatalogName() + "." + model.getSchemaName();
            schema2 = this.schemaRepository.getSchema(fullSchemaName);
            catalog = this.catalogRepository.getCatalog(model.getCatalogName());
            resourceIds.put(SecurableType.REGISTERED_MODEL, UUID.fromString(model.getId()));
            resourceIds.put(SecurableType.SCHEMA, UUID.fromString(schema2.getSchemaId()));
            resourceIds.put(SecurableType.CATALOG, UUID.fromString(catalog.getId()));
        }
        if (resourceKeys.containsKey((Object)SecurableType.CATALOG) && resourceKeys.containsKey((Object)SecurableType.SCHEMA)) {
            fullName = String.valueOf(resourceKeys.get((Object)SecurableType.CATALOG)) + "." + String.valueOf(resourceKeys.get((Object)SecurableType.SCHEMA));
            schema = this.schemaRepository.getSchema((String)fullName);
            resourceIds.put(SecurableType.SCHEMA, UUID.fromString(schema.getSchemaId()));
        }
        if (!resourceKeys.containsKey((Object)SecurableType.CATALOG) && resourceKeys.containsKey((Object)SecurableType.SCHEMA)) {
            fullName = (String)resourceKeys.get((Object)SecurableType.SCHEMA);
            schema = this.schemaRepository.getSchema((String)fullName);
            CatalogInfo catalog2 = this.catalogRepository.getCatalog(schema.getCatalogName());
            resourceIds.put(SecurableType.SCHEMA, UUID.fromString(schema.getSchemaId()));
            resourceIds.put(SecurableType.CATALOG, UUID.fromString(catalog2.getId()));
        }
        if (resourceKeys.containsKey((Object)SecurableType.CATALOG)) {
            fullName = (String)resourceKeys.get((Object)SecurableType.CATALOG);
            CatalogInfo catalog3 = this.catalogRepository.getCatalog((String)fullName);
            resourceIds.put(SecurableType.CATALOG, UUID.fromString(catalog3.getId()));
        }
        if (resourceKeys.containsKey((Object)SecurableType.METASTORE)) {
            resourceIds.put(SecurableType.METASTORE, this.metastoreRepository.getMetastoreId());
        }
        return resourceIds;
    }
}

