/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.auth.decorator;

import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.model.SecurableType;
import io.unitycatalog.server.persist.model.Privileges;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class UnityAccessEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnityAccessEvaluator.class);
    private final UnityCatalogAuthorizer authorizer;
    private final ExpressionParser parser;
    private final MethodHandle authorizeHandle;
    private final MethodHandle authorizeAnyHandle;
    private final MethodHandle authorizeAllHandle;

    public UnityAccessEvaluator(UnityCatalogAuthorizer authorizer) throws NoSuchMethodException, IllegalAccessException {
        this.authorizer = authorizer;
        this.parser = new SpelExpressionParser();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodType mt = MethodType.methodType(Boolean.TYPE, UUID.class, UUID.class, Privileges.class);
        MethodHandle mh = lookup.findVirtual(authorizer.getClass(), "authorize", mt);
        this.authorizeHandle = mh.bindTo(this.authorizer);
        mt = MethodType.methodType(Boolean.TYPE, Object[].class);
        mh = lookup.findVirtual(this.getClass(), "authorizeAny", mt);
        this.authorizeAnyHandle = mh.bindTo(this);
        mt = MethodType.methodType(Boolean.TYPE, Object[].class);
        mh = lookup.findVirtual(this.getClass(), "authorizeAll", mt);
        this.authorizeAllHandle = mh.bindTo(this);
    }

    protected boolean authorizeAny(Object ... parameters) {
        UUID principalId = (UUID)parameters[0];
        UUID resource = (UUID)parameters[1];
        Privileges[] privileges = new Privileges[parameters.length - 2];
        System.arraycopy(parameters, 2, privileges, 0, privileges.length);
        return this.authorizer.authorizeAny(principalId, resource, privileges);
    }

    protected boolean authorizeAll(Object ... parameters) {
        UUID principalId = (UUID)parameters[0];
        UUID resource = (UUID)parameters[1];
        Privileges[] privileges = new Privileges[parameters.length - 2];
        System.arraycopy(parameters, 2, privileges, 0, privileges.length);
        return this.authorizer.authorizeAll(principalId, resource, privileges);
    }

    public boolean evaluate(UUID principal, String expression, Map<SecurableType, Object> resourceIds) {
        StandardEvaluationContext context = new StandardEvaluationContext(Privileges.class);
        context.registerFunction("authorize", this.authorizeHandle);
        context.registerFunction("authorizeAny", this.authorizeAnyHandle);
        context.registerFunction("authorizeAll", this.authorizeAllHandle);
        context.setVariable("deny", (Object)Boolean.FALSE);
        context.setVariable("permit", (Object)Boolean.TRUE);
        context.setVariable("defer", (Object)Boolean.TRUE);
        context.setVariable("principal", (Object)principal);
        resourceIds.forEach((k, v) -> context.setVariable(k.name().toLowerCase(), v));
        Boolean result = (Boolean)this.parser.parseExpression(expression).getValue((EvaluationContext)context, Boolean.class);
        LOGGER.debug("evaluating {} = {}", (Object)expression, (Object)result);
        return result != null ? result : false;
    }

    public <T> void filter(UUID principalId, String expression, List<T> entries, Function<T, Map<SecurableType, Object>> resolver) {
        entries.removeIf(c -> !this.evaluate(principalId, expression, (Map)resolver.apply(c)));
    }
}

