/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.auth.decorator;

import io.unitycatalog.control.model.User;
import io.unitycatalog.server.auth.UnityCatalogAuthorizer;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.persist.model.CreateUser;
import io.unitycatalog.server.persist.model.Privileges;
import java.util.UUID;

public class UnityAccessUtil {
    private final UserRepository userRepository;
    private final MetastoreRepository metastoreRepository;

    public UnityAccessUtil(Repositories repositories) {
        this.userRepository = repositories.getUserRepository();
        this.metastoreRepository = repositories.getMetastoreRepository();
    }

    public void initializeAdmin(UnityCatalogAuthorizer authorizer) {
        try {
            this.userRepository.getUserByEmail("admin");
            return;
        }
        catch (BaseException baseException) {
            CreateUser createUser = CreateUser.builder().email("admin").name("Admin").build();
            User adminUser = this.userRepository.createUser(createUser);
            authorizer.grantAuthorization(UUID.fromString(adminUser.getId()), this.metastoreRepository.getMetastoreId(), Privileges.OWNER);
            return;
        }
    }
}

