/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.exception;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.unboundid.scim2.common.exceptions.ScimException;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.exception.Scim2RuntimeException;
import io.unitycatalog.server.utils.RESTObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobalExceptionHandler
implements ExceptionHandlerFunction {
    public HttpResponse handleException(ServiceRequestContext ctx, HttpRequest req, Throwable cause) {
        if (cause instanceof BaseException) {
            BaseException baseException = (BaseException)cause;
            return HttpResponse.ofJson((HttpStatus)baseException.getErrorCode().getHttpStatus(), this.createErrorResponse(baseException.getErrorCode(), baseException.getErrorMessage(), baseException.getCause(), baseException.getMetadata()));
        }
        if (cause instanceof Scim2RuntimeException) {
            ScimException scimException = (ScimException)cause.getCause();
            return HttpResponse.ofJson((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (Object)RESTObjectMapper.mapper().writeValueAsString((Object)scimException.getScimError()));
        }
        if (cause instanceof RuntimeException) {
            return HttpResponse.ofJson((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, this.createErrorResponse(ErrorCode.INTERNAL, cause.getMessage(), cause, new HashMap<String, String>()));
        }
        return (HttpResponse)ExceptionHandlerFunction.fallthrough();
    }

    private Map<String, Object> createErrorResponse(ErrorCode errorCode, String message, Throwable cause, Map<String, String> metadata) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("error_code", errorCode.name());
        response.put("message", message);
        response.put("stack_trace", cause != null ? Arrays.toString(cause.getStackTrace()) : null);
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("@type", "google.rpc.ErrorInfo");
        details.put("reason", errorCode.name());
        details.put("metadata", metadata);
        response.put("details", List.of(details));
        return response;
    }
}

