/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.exception;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.utils.RESTObjectMapper;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.BadRequestException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.rest.responses.ErrorResponse;

public class IcebergRestExceptionHandler
implements ExceptionHandlerFunction {
    public HttpResponse handleException(ServiceRequestContext ctx, HttpRequest req, Throwable cause) {
        try {
            if (cause instanceof BaseException) {
                return this.handleBaseException((BaseException)cause);
            }
            if (cause instanceof NoSuchNamespaceException || cause instanceof NoSuchTableException || cause instanceof NoSuchViewException) {
                return this.createErrorResponse(HttpStatus.NOT_FOUND, cause);
            }
            if (cause instanceof AlreadyExistsException || cause instanceof NamespaceNotEmptyException || cause instanceof CommitFailedException) {
                return this.createErrorResponse(HttpStatus.CONFLICT, cause);
            }
            if (cause instanceof IllegalArgumentException || cause instanceof BadRequestException) {
                return this.createErrorResponse(HttpStatus.BAD_REQUEST, cause);
            }
            return this.createErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR, cause);
        }
        catch (Exception e) {
            return HttpResponse.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private HttpResponse handleBaseException(BaseException exception) {
        return this.createErrorResponse(exception.getErrorCode().getHttpStatus(), exception);
    }

    private HttpResponse createErrorResponse(HttpStatus status, Throwable cause) {
        return HttpResponse.of((HttpStatus)status, (MediaType)MediaType.JSON, (String)RESTObjectMapper.mapper().writeValueAsString((Object)ErrorResponse.builder().responseCode(Integer.valueOf(status.code())).withType(cause.getClass().getSimpleName()).withMessage(cause.getMessage()).build()));
    }
}

