/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "comment", "properties"})
public class CreateCatalog {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private Map<String, String> properties = new HashMap<String, String>();

    public CreateCatalog name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateCatalog comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public CreateCatalog properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public CreateCatalog putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCatalog createCatalog = (CreateCatalog)o;
        return Objects.equals(this.name, createCatalog.name) && Objects.equals(this.comment, createCatalog.comment) && Objects.equals(this.properties, createCatalog.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comment, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCatalog {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

