/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum DataSourceFormat {
    DELTA("DELTA"),
    CSV("CSV"),
    JSON("JSON"),
    AVRO("AVRO"),
    PARQUET("PARQUET"),
    ORC("ORC"),
    TEXT("TEXT");

    private String value;

    private DataSourceFormat(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static DataSourceFormat fromValue(String value) {
        for (DataSourceFormat b : DataSourceFormat.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

