/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.server.model.CredentialInfo;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"credentials", "next_page_token"})
public class ListCredentialsResponse {
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private List<CredentialInfo> credentials = new ArrayList<CredentialInfo>();
    public static final String JSON_PROPERTY_NEXT_PAGE_TOKEN = "next_page_token";
    private String nextPageToken;

    public ListCredentialsResponse credentials(List<CredentialInfo> credentials) {
        this.credentials = credentials;
        return this;
    }

    public ListCredentialsResponse addCredentialsItem(CredentialInfo credentialsItem) {
        if (this.credentials == null) {
            this.credentials = new ArrayList<CredentialInfo>();
        }
        this.credentials.add(credentialsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CredentialInfo> getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(List<CredentialInfo> credentials) {
        this.credentials = credentials;
    }

    public ListCredentialsResponse nextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="next_page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    @JsonProperty(value="next_page_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListCredentialsResponse listCredentialsResponse = (ListCredentialsResponse)o;
        return Objects.equals(this.credentials, listCredentialsResponse.credentials) && Objects.equals(this.nextPageToken, listCredentialsResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.nextPageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListCredentialsResponse {\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    nextPageToken: ").append(this.toIndentedString(this.nextPageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

