/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.unitycatalog.server.model.Privilege;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"principal", "privileges"})
public class PrivilegeAssignment {
    public static final String JSON_PROPERTY_PRINCIPAL = "principal";
    private String principal;
    public static final String JSON_PROPERTY_PRIVILEGES = "privileges";
    private List<Privilege> privileges = new ArrayList<Privilege>();

    public PrivilegeAssignment principal(String principal) {
        this.principal = principal;
        return this;
    }

    @Nonnull
    @JsonProperty(value="principal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPrincipal() {
        return this.principal;
    }

    @JsonProperty(value="principal")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public PrivilegeAssignment privileges(List<Privilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    public PrivilegeAssignment addPrivilegesItem(Privilege privilegesItem) {
        if (this.privileges == null) {
            this.privileges = new ArrayList<Privilege>();
        }
        this.privileges.add(privilegesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="privileges")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<Privilege> getPrivileges() {
        return this.privileges;
    }

    @JsonProperty(value="privileges")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrivileges(List<Privilege> privileges) {
        this.privileges = privileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeAssignment privilegeAssignment = (PrivilegeAssignment)o;
        return Objects.equals(this.principal, privilegeAssignment.principal) && Objects.equals(this.privileges, privilegeAssignment.privileges);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.privileges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegeAssignment {\n");
        sb.append("    principal: ").append(this.toIndentedString(this.principal)).append("\n");
        sb.append("    privileges: ").append(this.toIndentedString(this.privileges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

