/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist;

import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.model.CatalogInfo;
import io.unitycatalog.server.model.CreateCatalog;
import io.unitycatalog.server.model.ListCatalogsResponse;
import io.unitycatalog.server.model.ListSchemasResponse;
import io.unitycatalog.server.model.SchemaInfo;
import io.unitycatalog.server.model.UpdateCatalog;
import io.unitycatalog.server.persist.PropertyRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.dao.CatalogInfoDAO;
import io.unitycatalog.server.persist.dao.PropertyDAO;
import io.unitycatalog.server.persist.utils.PagedListingHelper;
import io.unitycatalog.server.persist.utils.RepositoryUtils;
import io.unitycatalog.server.persist.utils.TransactionManager;
import io.unitycatalog.server.utils.IdentityUtils;
import io.unitycatalog.server.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CatalogRepository.class);
    private final Repositories repositories;
    private final SessionFactory sessionFactory;
    private static final PagedListingHelper<CatalogInfoDAO> LISTING_HELPER = new PagedListingHelper<CatalogInfoDAO>(CatalogInfoDAO.class);

    public CatalogRepository(Repositories repositories, SessionFactory sessionFactory) {
        this.repositories = repositories;
        this.sessionFactory = sessionFactory;
    }

    public CatalogInfo addCatalog(CreateCatalog createCatalog) {
        ValidationUtils.validateSqlObjectName(createCatalog.getName());
        String callerId = IdentityUtils.findPrincipalEmailAddress();
        Long createTime = System.currentTimeMillis();
        CatalogInfo catalogInfo = new CatalogInfo().id(UUID.randomUUID().toString()).comment(createCatalog.getComment()).name(createCatalog.getName()).owner(callerId).createdAt(createTime).createdBy(callerId).updatedAt(createTime).updatedBy(callerId).properties(createCatalog.getProperties());
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            if (this.getCatalogDAO(session, createCatalog.getName()) != null) {
                throw new BaseException(ErrorCode.ALREADY_EXISTS, "Catalog already exists: " + createCatalog.getName());
            }
            CatalogInfoDAO catalogInfoDAO = CatalogInfoDAO.from(catalogInfo);
            PropertyDAO.from(catalogInfo.getProperties(), catalogInfoDAO.getId(), "catalog").forEach(arg_0 -> ((Session)session).persist(arg_0));
            session.persist((Object)catalogInfoDAO);
            LOGGER.info("Added catalog: {}", (Object)catalogInfo.getName());
            return catalogInfo;
        }, "Failed to add catalog", false);
    }

    public ListCatalogsResponse listCatalogs(Optional<Integer> maxResults, Optional<String> pageToken) {
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> this.listCatalogs(session, maxResults, pageToken), "Failed to list catalogs", true);
    }

    public ListCatalogsResponse listCatalogs(Session session, Optional<Integer> maxResults, Optional<String> pageToken) {
        List<CatalogInfoDAO> catalogInfoDAOList = LISTING_HELPER.listEntity(session, maxResults, pageToken, null);
        String nextPageToken = LISTING_HELPER.getNextPageToken(catalogInfoDAOList, maxResults);
        ArrayList<CatalogInfo> result = new ArrayList<CatalogInfo>();
        for (CatalogInfoDAO catalogInfoDAO : catalogInfoDAOList) {
            CatalogInfo catalogInfo = catalogInfoDAO.toCatalogInfo();
            RepositoryUtils.attachProperties(catalogInfo, catalogInfo.getId(), "catalog", session);
            result.add(catalogInfo);
        }
        return new ListCatalogsResponse().catalogs(result).nextPageToken(nextPageToken);
    }

    public CatalogInfo getCatalog(String name) {
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            CatalogInfoDAO catalogInfoDAO = this.getCatalogDAO(session, name);
            if (catalogInfoDAO == null) {
                throw new BaseException(ErrorCode.NOT_FOUND, "Catalog not found: " + name);
            }
            CatalogInfo catalogInfo = catalogInfoDAO.toCatalogInfo();
            return RepositoryUtils.attachProperties(catalogInfo, catalogInfo.getId(), "catalog", session);
        }, "Failed to get catalog", true);
    }

    public CatalogInfoDAO getCatalogDAO(Session session, String name) {
        Query query = session.createQuery("FROM CatalogInfoDAO WHERE name = :value", CatalogInfoDAO.class);
        query.setParameter("value", (Object)name);
        query.setMaxResults(1);
        return (CatalogInfoDAO)query.uniqueResult();
    }

    public CatalogInfo updateCatalog(String name, UpdateCatalog updateCatalog) {
        if (updateCatalog.getNewName() != null) {
            ValidationUtils.validateSqlObjectName(updateCatalog.getNewName());
        }
        String callerId = IdentityUtils.findPrincipalEmailAddress();
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            CatalogInfoDAO catalogInfoDAO = this.getCatalogDAO(session, name);
            if (catalogInfoDAO == null) {
                throw new BaseException(ErrorCode.NOT_FOUND, "Catalog not found: " + name);
            }
            if (updateCatalog.getNewName() == null && updateCatalog.getComment() == null && (updateCatalog.getProperties() == null || updateCatalog.getProperties().isEmpty())) {
                CatalogInfo catalogInfo = catalogInfoDAO.toCatalogInfo();
                return RepositoryUtils.attachProperties(catalogInfo, catalogInfo.getId(), "catalog", session);
            }
            if (updateCatalog.getNewName() != null && this.getCatalogDAO(session, updateCatalog.getNewName()) != null) {
                throw new BaseException(ErrorCode.ALREADY_EXISTS, "Catalog already exists: " + updateCatalog.getNewName());
            }
            if (updateCatalog.getNewName() != null) {
                catalogInfoDAO.setName(updateCatalog.getNewName());
            }
            if (updateCatalog.getComment() != null) {
                catalogInfoDAO.setComment(updateCatalog.getComment());
            }
            if (updateCatalog.getProperties() != null && !updateCatalog.getProperties().isEmpty()) {
                PropertyRepository.findProperties(session, catalogInfoDAO.getId(), "catalog").forEach(arg_0 -> ((Session)session).remove(arg_0));
                session.flush();
                PropertyDAO.from(updateCatalog.getProperties(), catalogInfoDAO.getId(), "catalog").forEach(arg_0 -> ((Session)session).persist(arg_0));
            }
            catalogInfoDAO.setUpdatedAt(new Date());
            catalogInfoDAO.setUpdatedBy(callerId);
            session.merge((Object)catalogInfoDAO);
            CatalogInfo catalogInfo = catalogInfoDAO.toCatalogInfo();
            return RepositoryUtils.attachProperties(catalogInfo, catalogInfo.getId(), "catalog", session);
        }, "Failed to update catalog", false);
    }

    public void deleteCatalog(String name, boolean force) {
        TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            CatalogInfoDAO catalogInfo = this.getCatalogDAO(session, name);
            if (catalogInfo == null) {
                throw new BaseException(ErrorCode.NOT_FOUND, "Catalog not found: " + name);
            }
            ListSchemasResponse initialSchemaCheck = this.repositories.getSchemaRepository().listSchemas(session, catalogInfo.getId(), catalogInfo.getName(), Optional.of(1), Optional.empty());
            if (!initialSchemaCheck.getSchemas().isEmpty() && !force) {
                throw new BaseException(ErrorCode.FAILED_PRECONDITION, "Cannot delete catalog with schemas. Use force=true to force deletion.");
            }
            if (force) {
                ListSchemasResponse schemaResponse;
                String nextPageToken = null;
                do {
                    schemaResponse = this.repositories.getSchemaRepository().listSchemas(session, catalogInfo.getId(), catalogInfo.getName(), Optional.empty(), Optional.ofNullable(nextPageToken));
                    for (SchemaInfo schema : schemaResponse.getSchemas()) {
                        this.repositories.getSchemaRepository().deleteSchema(session, catalogInfo.getId(), catalogInfo.getName(), schema.getName(), force);
                    }
                } while ((nextPageToken = schemaResponse.getNextPageToken()) != null);
            }
            PropertyRepository.findProperties(session, catalogInfo.getId(), "catalog").forEach(arg_0 -> ((Session)session).remove(arg_0));
            session.remove((Object)catalogInfo);
            LOGGER.info("Deleted catalog: {}", (Object)name);
            return null;
        }, "Failed to delete catalog", false);
    }
}

