/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist;

import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.model.CreateExternalLocation;
import io.unitycatalog.server.model.CredentialPurpose;
import io.unitycatalog.server.model.ExternalLocationInfo;
import io.unitycatalog.server.model.ListExternalLocationsResponse;
import io.unitycatalog.server.model.UpdateExternalLocation;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.dao.CredentialDAO;
import io.unitycatalog.server.persist.dao.ExternalLocationDAO;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import io.unitycatalog.server.persist.utils.PagedListingHelper;
import io.unitycatalog.server.persist.utils.TransactionManager;
import io.unitycatalog.server.utils.IdentityUtils;
import io.unitycatalog.server.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalLocationRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalLocationRepository.class);
    private final Repositories repositories;
    private final SessionFactory sessionFactory;
    private static final PagedListingHelper<ExternalLocationDAO> LISTING_HELPER = new PagedListingHelper<ExternalLocationDAO>(ExternalLocationDAO.class);

    public ExternalLocationRepository(Repositories repositories, SessionFactory sessionFactory) {
        this.repositories = repositories;
        this.sessionFactory = sessionFactory;
    }

    private CredentialDAO validateAndGetCredentialDAO(Session session, String credentialName) {
        CredentialDAO credentialDAO = this.repositories.getCredentialRepository().getCredentialDAO(session, credentialName);
        if (credentialDAO == null) {
            throw new BaseException(ErrorCode.NOT_FOUND, "Credential not found: " + credentialName);
        }
        if (!credentialDAO.getPurpose().equals((Object)CredentialPurpose.STORAGE)) {
            throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Credential not of type storage: " + credentialName);
        }
        return credentialDAO;
    }

    public ExternalLocationDAO addExternalLocation(CreateExternalLocation createExternalLocation) {
        ValidationUtils.validateSqlObjectName(createExternalLocation.getName());
        String callerId = IdentityUtils.findPrincipalEmailAddress();
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            if (this.getExternalLocationDAO(session, createExternalLocation.getName()) != null) {
                throw new BaseException(ErrorCode.ALREADY_EXISTS, "External location already exists: " + createExternalLocation.getName());
            }
            CredentialDAO credentialDAO = this.validateAndGetCredentialDAO(session, createExternalLocation.getCredentialName());
            UUID externalLocationId = UUID.randomUUID();
            IdentifiableDAO externalLocationDAO = ((ExternalLocationDAO.ExternalLocationDAOBuilder)((ExternalLocationDAO.ExternalLocationDAOBuilder)((ExternalLocationDAO.ExternalLocationDAOBuilder)((ExternalLocationDAO.ExternalLocationDAOBuilder)((ExternalLocationDAO.ExternalLocationDAOBuilder)((ExternalLocationDAO.ExternalLocationDAOBuilder)((ExternalLocationDAO.ExternalLocationDAOBuilder)((ExternalLocationDAO.ExternalLocationDAOBuilder)ExternalLocationDAO.builder().id(externalLocationId)).name(createExternalLocation.getName())).url(createExternalLocation.getUrl())).comment(createExternalLocation.getComment())).owner(callerId)).credentialId(credentialDAO.getId())).createdAt(new Date())).createdBy(callerId)).build();
            session.persist((Object)externalLocationDAO);
            LOGGER.info("External location added: {}", (Object)externalLocationDAO.getName());
            return externalLocationDAO;
        }, "Failed to add external location", false);
    }

    public ExternalLocationInfo getExternalLocation(String name) {
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            ExternalLocationDAO externalLocationDAO = this.getExternalLocationDAO(session, name);
            if (externalLocationDAO == null) {
                throw new BaseException(ErrorCode.NOT_FOUND, "External location not found: " + name);
            }
            LOGGER.info("External location retrieved: {}", (Object)externalLocationDAO.getName());
            return externalLocationDAO.toExternalLocationInfo();
        }, "Failed to get external location", true);
    }

    protected ExternalLocationDAO getExternalLocationDAO(Session session, String name) {
        Query query = session.createQuery("FROM ExternalLocationDAO WHERE name = :value", ExternalLocationDAO.class);
        query.setParameter("value", (Object)name);
        query.setMaxResults(1);
        return (ExternalLocationDAO)query.uniqueResult();
    }

    public ListExternalLocationsResponse listExternalLocations(Optional<Integer> maxResults, Optional<String> pageToken) {
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            List<ExternalLocationDAO> daoList = LISTING_HELPER.listEntity(session, maxResults, pageToken, null);
            String nextPageToken = LISTING_HELPER.getNextPageToken(daoList, maxResults);
            ArrayList<ExternalLocationInfo> results = new ArrayList<ExternalLocationInfo>();
            for (ExternalLocationDAO dao : daoList) {
                results.add(dao.toExternalLocationInfo());
            }
            return new ListExternalLocationsResponse().externalLocations(results).nextPageToken(nextPageToken);
        }, "Failed to list external locations", true);
    }

    public ExternalLocationInfo updateExternalLocation(String name, UpdateExternalLocation updateExternalLocation) {
        String callerId = IdentityUtils.findPrincipalEmailAddress();
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            ExternalLocationDAO existingLocation = this.getExternalLocationDAO(session, name);
            if (existingLocation == null) {
                throw new BaseException(ErrorCode.NOT_FOUND, "External location not found: " + name);
            }
            if (updateExternalLocation.getNewName() != null) {
                ValidationUtils.validateSqlObjectName(updateExternalLocation.getNewName());
                if (this.getExternalLocationDAO(session, updateExternalLocation.getNewName()) != null) {
                    throw new BaseException(ErrorCode.ALREADY_EXISTS, "External location already exists: " + updateExternalLocation.getNewName());
                }
                existingLocation.setName(updateExternalLocation.getNewName());
            }
            if (updateExternalLocation.getUrl() != null) {
                existingLocation.setUrl(updateExternalLocation.getUrl());
            }
            if (updateExternalLocation.getComment() != null) {
                existingLocation.setComment(updateExternalLocation.getComment());
            }
            if (updateExternalLocation.getCredentialName() != null) {
                CredentialDAO credentialDAO = this.validateAndGetCredentialDAO(session, updateExternalLocation.getCredentialName());
                existingLocation.setCredentialId(credentialDAO.getId());
            }
            existingLocation.setUpdatedAt(new Date());
            existingLocation.setUpdatedBy(callerId);
            session.merge((Object)existingLocation);
            LOGGER.info("Updated external location: {}", (Object)name);
            return existingLocation.toExternalLocationInfo();
        }, "Failed to update external location", false);
    }

    public ExternalLocationDAO deleteExternalLocation(String name) {
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            ExternalLocationDAO existingLocation = this.getExternalLocationDAO(session, name);
            if (existingLocation == null) {
                throw new BaseException(ErrorCode.NOT_FOUND, "External location not found: " + name);
            }
            session.remove((Object)existingLocation);
            LOGGER.info("Deleted external location: {}", (Object)name);
            return existingLocation;
        }, "Failed to delete external location", false);
    }
}

