/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist;

import io.unitycatalog.server.persist.CatalogRepository;
import io.unitycatalog.server.persist.CredentialRepository;
import io.unitycatalog.server.persist.ExternalLocationRepository;
import io.unitycatalog.server.persist.FunctionRepository;
import io.unitycatalog.server.persist.MetastoreRepository;
import io.unitycatalog.server.persist.ModelRepository;
import io.unitycatalog.server.persist.SchemaRepository;
import io.unitycatalog.server.persist.TableRepository;
import io.unitycatalog.server.persist.UserRepository;
import io.unitycatalog.server.persist.VolumeRepository;
import io.unitycatalog.server.persist.utils.FileOperations;
import io.unitycatalog.server.utils.ServerProperties;
import org.hibernate.SessionFactory;

public class Repositories {
    private final SessionFactory sessionFactory;
    private final FileOperations fileOperations;
    private final CatalogRepository catalogRepository;
    private final SchemaRepository schemaRepository;
    private final TableRepository tableRepository;
    private final VolumeRepository volumeRepository;
    private final UserRepository userRepository;
    private final MetastoreRepository metastoreRepository;
    private final FunctionRepository functionRepository;
    private final ModelRepository modelRepository;
    private final CredentialRepository credentialRepository;
    private final ExternalLocationRepository externalLocationRepository;

    public Repositories(SessionFactory sessionFactory, ServerProperties serverProperties) {
        this.sessionFactory = sessionFactory;
        this.fileOperations = new FileOperations(serverProperties);
        this.catalogRepository = new CatalogRepository(this, sessionFactory);
        this.schemaRepository = new SchemaRepository(this, sessionFactory);
        this.tableRepository = new TableRepository(this, sessionFactory);
        this.volumeRepository = new VolumeRepository(this, sessionFactory);
        this.userRepository = new UserRepository(this, sessionFactory);
        this.metastoreRepository = new MetastoreRepository(this, sessionFactory);
        this.functionRepository = new FunctionRepository(this, sessionFactory);
        this.modelRepository = new ModelRepository(this, sessionFactory);
        this.credentialRepository = new CredentialRepository(this, sessionFactory);
        this.externalLocationRepository = new ExternalLocationRepository(this, sessionFactory);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public FileOperations getFileOperations() {
        return this.fileOperations;
    }

    public CatalogRepository getCatalogRepository() {
        return this.catalogRepository;
    }

    public SchemaRepository getSchemaRepository() {
        return this.schemaRepository;
    }

    public TableRepository getTableRepository() {
        return this.tableRepository;
    }

    public VolumeRepository getVolumeRepository() {
        return this.volumeRepository;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    public MetastoreRepository getMetastoreRepository() {
        return this.metastoreRepository;
    }

    public FunctionRepository getFunctionRepository() {
        return this.functionRepository;
    }

    public ModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public CredentialRepository getCredentialRepository() {
        return this.credentialRepository;
    }

    public ExternalLocationRepository getExternalLocationRepository() {
        return this.externalLocationRepository;
    }
}

