/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist;

import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.model.CreateSchema;
import io.unitycatalog.server.model.FunctionInfo;
import io.unitycatalog.server.model.ListFunctionsResponse;
import io.unitycatalog.server.model.ListRegisteredModelsResponse;
import io.unitycatalog.server.model.ListSchemasResponse;
import io.unitycatalog.server.model.ListTablesResponse;
import io.unitycatalog.server.model.ListVolumesResponseContent;
import io.unitycatalog.server.model.RegisteredModelInfo;
import io.unitycatalog.server.model.SchemaInfo;
import io.unitycatalog.server.model.TableInfo;
import io.unitycatalog.server.model.UpdateSchema;
import io.unitycatalog.server.model.VolumeInfo;
import io.unitycatalog.server.persist.PropertyRepository;
import io.unitycatalog.server.persist.Repositories;
import io.unitycatalog.server.persist.dao.CatalogInfoDAO;
import io.unitycatalog.server.persist.dao.PropertyDAO;
import io.unitycatalog.server.persist.dao.SchemaInfoDAO;
import io.unitycatalog.server.persist.utils.PagedListingHelper;
import io.unitycatalog.server.persist.utils.RepositoryUtils;
import io.unitycatalog.server.persist.utils.TransactionManager;
import io.unitycatalog.server.utils.IdentityUtils;
import io.unitycatalog.server.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public class SchemaRepository {
    private final Repositories repositories;
    private final SessionFactory sessionFactory;
    private static final PagedListingHelper<SchemaInfoDAO> LISTING_HELPER = new PagedListingHelper<SchemaInfoDAO>(SchemaInfoDAO.class);

    public SchemaRepository(Repositories repositories, SessionFactory sessionFactory) {
        this.repositories = repositories;
        this.sessionFactory = sessionFactory;
    }

    public SchemaInfo createSchema(CreateSchema createSchema) {
        ValidationUtils.validateSqlObjectName(createSchema.getName());
        String callerId = IdentityUtils.findPrincipalEmailAddress();
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            if (this.getSchemaDAO(session, createSchema.getCatalogName(), createSchema.getName()) != null) {
                throw new BaseException(ErrorCode.ALREADY_EXISTS, "Schema already exists: " + createSchema.getName());
            }
            CatalogInfoDAO catalogDAO = this.repositories.getCatalogRepository().getCatalogDAO(session, createSchema.getCatalogName());
            Long createTime = System.currentTimeMillis();
            SchemaInfo schemaInfo = new SchemaInfo().schemaId(UUID.randomUUID().toString()).name(createSchema.getName()).catalogName(createSchema.getCatalogName()).comment(createSchema.getComment()).owner(callerId).createdAt(createTime).createdBy(callerId).updatedAt(createTime).updatedBy(callerId).properties(createSchema.getProperties());
            SchemaInfoDAO schemaInfoDAO = SchemaInfoDAO.from(schemaInfo);
            schemaInfoDAO.setCatalogId(catalogDAO.getId());
            PropertyDAO.from(schemaInfo.getProperties(), schemaInfoDAO.getId(), "schema").forEach(arg_0 -> ((Session)session).persist(arg_0));
            session.persist((Object)schemaInfoDAO);
            this.addNamespaceData(schemaInfo, createSchema.getCatalogName());
            return schemaInfo;
        }, "Failed to create schema", false);
    }

    private void addNamespaceData(SchemaInfo schemaInfo, String catalogName) {
        schemaInfo.setCatalogName(catalogName);
        schemaInfo.setFullName(catalogName + "." + schemaInfo.getName());
    }

    private SchemaInfo convertFromDAO(Session session, SchemaInfoDAO schemaInfoDAO, String fullName) {
        String catalogName = fullName.split("\\.")[0];
        SchemaInfo schemaInfo = schemaInfoDAO.toSchemaInfo();
        this.addNamespaceData(schemaInfo, catalogName);
        return RepositoryUtils.attachProperties(schemaInfo, schemaInfo.getSchemaId(), "schema", session);
    }

    public SchemaInfoDAO getSchemaDAO(Session session, UUID catalogId, String schemaName) {
        Query query = session.createQuery("FROM SchemaInfoDAO WHERE name = :name and catalogId = :catalogId", SchemaInfoDAO.class);
        query.setParameter("name", (Object)schemaName);
        query.setParameter("catalogId", (Object)catalogId);
        query.setMaxResults(1);
        return (SchemaInfoDAO)query.uniqueResult();
    }

    public SchemaInfoDAO getSchemaDAO(Session session, String catalogName, String schemaName) {
        CatalogInfoDAO catalog = this.repositories.getCatalogRepository().getCatalogDAO(session, catalogName);
        if (catalog == null) {
            throw new BaseException(ErrorCode.NOT_FOUND, "Catalog not found: " + catalogName);
        }
        return this.getSchemaDAO(session, catalog.getId(), schemaName);
    }

    public SchemaInfoDAO getSchemaDAO(Session session, String fullName) {
        String[] namespace = fullName.split("\\.");
        return this.getSchemaDAO(session, namespace[0], namespace[1]);
    }

    public UUID getCatalogId(Session session, String catalogName) {
        CatalogInfoDAO catalogInfo = this.repositories.getCatalogRepository().getCatalogDAO(session, catalogName);
        if (catalogInfo == null) {
            throw new BaseException(ErrorCode.NOT_FOUND, "Catalog not found: " + catalogName);
        }
        return catalogInfo.getId();
    }

    public ListSchemasResponse listSchemas(String catalogName, Optional<Integer> maxResults, Optional<String> pageToken) {
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            UUID catalogId = this.getCatalogId(session, catalogName);
            return this.listSchemas(session, catalogId, catalogName, maxResults, pageToken);
        }, "Failed to list schemas", true);
    }

    public ListSchemasResponse listSchemas(Session session, UUID catalogId, String catalogName, Optional<Integer> maxResults, Optional<String> pageToken) {
        List<SchemaInfoDAO> schemaInfoDAOList = LISTING_HELPER.listEntity(session, maxResults, pageToken, catalogId);
        String nextPageToken = LISTING_HELPER.getNextPageToken(schemaInfoDAOList, maxResults);
        ArrayList<SchemaInfo> result = new ArrayList<SchemaInfo>();
        for (SchemaInfoDAO schemaInfoDAO : schemaInfoDAOList) {
            SchemaInfo schemaInfo = schemaInfoDAO.toSchemaInfo();
            RepositoryUtils.attachProperties(schemaInfo, schemaInfo.getSchemaId(), "schema", session);
            this.addNamespaceData(schemaInfo, catalogName);
            result.add(schemaInfo);
        }
        return new ListSchemasResponse().schemas(result).nextPageToken(nextPageToken);
    }

    public SchemaInfo getSchema(String fullName) {
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            SchemaInfoDAO schemaInfoDAO = this.getSchemaDAO(session, fullName);
            if (schemaInfoDAO == null) {
                throw new BaseException(ErrorCode.NOT_FOUND, "Schema not found: " + fullName);
            }
            SchemaInfo schemaInfo = this.convertFromDAO(session, schemaInfoDAO, fullName);
            return RepositoryUtils.attachProperties(schemaInfo, schemaInfo.getSchemaId(), "schema", session);
        }, "Failed to get schema", true);
    }

    public SchemaInfo updateSchema(String fullName, UpdateSchema updateSchema) {
        if (updateSchema.getNewName() != null) {
            ValidationUtils.validateSqlObjectName(updateSchema.getNewName());
        }
        String callerId = IdentityUtils.findPrincipalEmailAddress();
        return TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            SchemaInfoDAO schemaInfoDAO = this.getSchemaDAO(session, fullName);
            if (schemaInfoDAO == null) {
                throw new BaseException(ErrorCode.NOT_FOUND, "Schema not found: " + fullName);
            }
            if (updateSchema.getNewName() != null && this.getSchemaDAO(session, fullName.split("\\.")[0], updateSchema.getNewName()) != null) {
                throw new BaseException(ErrorCode.ALREADY_EXISTS, "Schema already exists: " + updateSchema.getNewName());
            }
            if (updateSchema.getComment() == null && updateSchema.getNewName() == null && (updateSchema.getProperties() == null || updateSchema.getProperties().isEmpty())) {
                return this.convertFromDAO(session, schemaInfoDAO, fullName);
            }
            if (updateSchema.getComment() != null) {
                schemaInfoDAO.setComment(updateSchema.getComment());
            }
            if (updateSchema.getNewName() != null) {
                schemaInfoDAO.setName(updateSchema.getNewName());
            }
            if (updateSchema.getProperties() != null && !updateSchema.getProperties().isEmpty()) {
                PropertyRepository.findProperties(session, schemaInfoDAO.getId(), "schema").forEach(arg_0 -> ((Session)session).remove(arg_0));
                session.flush();
                PropertyDAO.from(updateSchema.getProperties(), schemaInfoDAO.getId(), "schema").forEach(arg_0 -> ((Session)session).persist(arg_0));
            }
            schemaInfoDAO.setUpdatedAt(new Date());
            schemaInfoDAO.setUpdatedBy(callerId);
            session.merge((Object)schemaInfoDAO);
            return this.convertFromDAO(session, schemaInfoDAO, fullName);
        }, "Failed to update schema", false);
    }

    public void deleteSchema(String fullName, boolean force) {
        TransactionManager.executeWithTransaction(this.sessionFactory, session -> {
            String[] namespace = fullName.split("\\.");
            if (namespace.length != 2) {
                throw new BaseException(ErrorCode.INVALID_ARGUMENT, "Invalid schema name: " + fullName);
            }
            CatalogInfoDAO catalog = this.repositories.getCatalogRepository().getCatalogDAO(session, namespace[0]);
            if (catalog == null) {
                throw new BaseException(ErrorCode.NOT_FOUND, "Catalog not found: " + namespace[0]);
            }
            this.deleteSchema(session, catalog.getId(), namespace[0], namespace[1], force);
            return null;
        }, "Failed to delete schema", false);
    }

    public void processChildTables(Session session, UUID schemaId, String catalogName, String schemaName, boolean force) {
        List<TableInfo> tables = this.repositories.getTableRepository().listTables(session, schemaId, catalogName, schemaName, Optional.of(1), Optional.empty(), true, true).getTables();
        if (tables != null && !tables.isEmpty()) {
            ListTablesResponse listTablesResponse;
            if (!force) {
                throw new BaseException(ErrorCode.FAILED_PRECONDITION, "Cannot delete schema with tables");
            }
            String nextToken = null;
            do {
                listTablesResponse = this.repositories.getTableRepository().listTables(session, schemaId, catalogName, schemaName, Optional.empty(), Optional.ofNullable(nextToken), true, true);
                for (TableInfo tableInfo : listTablesResponse.getTables()) {
                    this.repositories.getTableRepository().deleteTable(session, schemaId, tableInfo.getName());
                }
            } while ((nextToken = listTablesResponse.getNextPageToken()) != null);
        }
    }

    public void processChildVolumes(Session session, UUID schemaId, String catalogName, String schemaName, boolean force) {
        List<VolumeInfo> volumes = this.repositories.getVolumeRepository().listVolumes(session, schemaId, catalogName, schemaName, Optional.of(1), Optional.empty()).getVolumes();
        if (volumes != null && !volumes.isEmpty()) {
            ListVolumesResponseContent listVolumesResponse;
            if (!force) {
                throw new BaseException(ErrorCode.FAILED_PRECONDITION, "Cannot delete schema with volumes");
            }
            String nextToken = null;
            do {
                listVolumesResponse = this.repositories.getVolumeRepository().listVolumes(session, schemaId, catalogName, schemaName, Optional.empty(), Optional.ofNullable(nextToken));
                for (VolumeInfo volumeInfo : listVolumesResponse.getVolumes()) {
                    this.repositories.getVolumeRepository().deleteVolume(session, schemaId, volumeInfo.getName());
                }
            } while ((nextToken = listVolumesResponse.getNextPageToken()) != null);
        }
    }

    public void processChildFunctions(Session session, UUID schemaId, String catalogName, String schemaName, boolean force) {
        List<FunctionInfo> functions = this.repositories.getFunctionRepository().listFunctions(session, schemaId, catalogName, schemaName, Optional.of(1), Optional.empty()).getFunctions();
        if (functions != null && !functions.isEmpty()) {
            ListFunctionsResponse listFunctionsResponse;
            if (!force) {
                throw new BaseException(ErrorCode.FAILED_PRECONDITION, "Cannot delete schema with functions");
            }
            String nextToken = null;
            do {
                listFunctionsResponse = this.repositories.getFunctionRepository().listFunctions(session, schemaId, catalogName, schemaName, Optional.empty(), Optional.ofNullable(nextToken));
                for (FunctionInfo functionInfo : listFunctionsResponse.getFunctions()) {
                    this.repositories.getFunctionRepository().deleteFunction(session, schemaId, functionInfo.getName());
                }
            } while ((nextToken = listFunctionsResponse.getNextPageToken()) != null);
        }
    }

    public void processChildModels(Session session, UUID schemaId, String catalogName, String schemaName, boolean force) {
        List<RegisteredModelInfo> registeredModels = this.repositories.getModelRepository().listRegisteredModels(session, schemaId, catalogName, schemaName, Optional.of(1), Optional.empty()).getRegisteredModels();
        if (registeredModels != null && !registeredModels.isEmpty()) {
            ListRegisteredModelsResponse listRegisteredModelsResponse;
            if (!force) {
                throw new BaseException(ErrorCode.FAILED_PRECONDITION, "Cannot delete schema with models");
            }
            String nextToken = null;
            do {
                listRegisteredModelsResponse = this.repositories.getModelRepository().listRegisteredModels(session, schemaId, catalogName, schemaName, Optional.empty(), Optional.ofNullable(nextToken));
                for (RegisteredModelInfo registeredModelInfo : listRegisteredModelsResponse.getRegisteredModels()) {
                    this.repositories.getModelRepository().deleteRegisteredModel(session, schemaId, registeredModelInfo.getName(), true);
                }
            } while ((nextToken = listRegisteredModelsResponse.getNextPageToken()) != null);
        }
    }

    public void deleteSchema(Session session, UUID catalogId, String catalogName, String schemaName, boolean force) {
        SchemaInfoDAO schemaInfo = this.getSchemaDAO(session, catalogId, schemaName);
        if (schemaInfo == null) {
            throw new BaseException(ErrorCode.NOT_FOUND, "Schema not found: " + schemaName);
        }
        this.processChildTables(session, schemaInfo.getId(), catalogName, schemaName, force);
        this.processChildVolumes(session, schemaInfo.getId(), catalogName, schemaName, force);
        this.processChildFunctions(session, schemaInfo.getId(), catalogName, schemaName, force);
        this.processChildModels(session, schemaInfo.getId(), catalogName, schemaName, force);
        session.remove((Object)schemaInfo);
        PropertyRepository.findProperties(session, schemaInfo.getId(), "schema").forEach(arg_0 -> ((Session)session).remove(arg_0));
    }
}

