/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.model.CatalogInfo;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;

@Entity
@Table(name="uc_catalogs")
public class CatalogInfoDAO
extends IdentifiableDAO {
    @Column(name="comment")
    private String comment;
    @Column(name="owner")
    private String owner;
    @Column(name="created_at")
    private Date createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Date updatedAt;
    @Column(name="updated_by")
    private String updatedBy;

    public static CatalogInfoDAO from(CatalogInfo catalogInfo) {
        return ((CatalogInfoDAOBuilder)((CatalogInfoDAOBuilder)((CatalogInfoDAOBuilder)((CatalogInfoDAOBuilder)((CatalogInfoDAOBuilder)((CatalogInfoDAOBuilder)((CatalogInfoDAOBuilder)((CatalogInfoDAOBuilder)CatalogInfoDAO.builder().id(catalogInfo.getId() != null ? UUID.fromString(catalogInfo.getId()) : null)).name(catalogInfo.getName())).comment(catalogInfo.getComment())).owner(catalogInfo.getOwner())).createdAt(catalogInfo.getCreatedAt() != null ? Date.from(Instant.ofEpochMilli(catalogInfo.getCreatedAt())) : new Date())).createdBy(catalogInfo.getCreatedBy())).updatedAt(catalogInfo.getUpdatedAt() != null ? Date.from(Instant.ofEpochMilli(catalogInfo.getUpdatedAt())) : null)).updatedBy(catalogInfo.getUpdatedBy())).build();
    }

    public CatalogInfo toCatalogInfo() {
        return new CatalogInfo().id(this.getId().toString()).name(this.getName()).comment(this.comment).owner(this.owner).createdAt(this.createdAt.getTime()).createdBy(this.createdBy).updatedAt(this.updatedAt != null ? Long.valueOf(this.updatedAt.getTime()) : null).updatedBy(this.updatedBy);
    }

    protected CatalogInfoDAO(CatalogInfoDAOBuilder<?, ?> b) {
        super(b);
        this.comment = b.comment;
        this.owner = b.owner;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
    }

    public static CatalogInfoDAOBuilder<?, ?> builder() {
        return new CatalogInfoDAOBuilderImpl();
    }

    public String getComment() {
        return this.comment;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public CatalogInfoDAO(String comment, String owner, Date createdAt, String createdBy, Date updatedAt, String updatedBy) {
        this.comment = comment;
        this.owner = owner;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
    }

    public CatalogInfoDAO() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatalogInfoDAO)) {
            return false;
        }
        CatalogInfoDAO other = (CatalogInfoDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        return !(this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CatalogInfoDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        return result;
    }

    public static abstract class CatalogInfoDAOBuilder<C extends CatalogInfoDAO, B extends CatalogInfoDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private String comment;
        private String owner;
        private Date createdAt;
        private String createdBy;
        private Date updatedAt;
        private String updatedBy;

        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        public B owner(String owner) {
            this.owner = owner;
            return (B)this.self();
        }

        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "CatalogInfoDAO.CatalogInfoDAOBuilder(super=" + super.toString() + ", comment=" + this.comment + ", owner=" + this.owner + ", createdAt=" + String.valueOf(this.createdAt) + ", createdBy=" + this.createdBy + ", updatedAt=" + String.valueOf(this.updatedAt) + ", updatedBy=" + this.updatedBy + ")";
        }
    }

    private static final class CatalogInfoDAOBuilderImpl
    extends CatalogInfoDAOBuilder<CatalogInfoDAO, CatalogInfoDAOBuilderImpl> {
        private CatalogInfoDAOBuilderImpl() {
        }

        @Override
        protected CatalogInfoDAOBuilderImpl self() {
            return this;
        }

        @Override
        public CatalogInfoDAO build() {
            return new CatalogInfoDAO(this);
        }
    }
}

