/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.model.ColumnInfo;
import io.unitycatalog.server.model.ColumnTypeName;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import io.unitycatalog.server.persist.dao.TableInfoDAO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Entity
@Table(name="uc_columns", uniqueConstraints={@UniqueConstraint(columnNames={"table_id", "ordinal_position", "name"})})
public class ColumnInfoDAO
extends IdentifiableDAO {
    @ManyToOne
    @JoinColumn(name="table_id", nullable=false, referencedColumnName="id")
    private TableInfoDAO table;
    @Column(name="ordinal_position", nullable=false)
    private short ordinalPosition;
    @Lob
    @Column(name="type_text", nullable=false, length=0xFFFFFF)
    private String typeText;
    @Column(name="type_json", nullable=false, length=0xFFFFFF)
    private String typeJson;
    @Column(name="type_name", nullable=false, length=32)
    private String typeName;
    @Column(name="type_precision")
    private Integer typePrecision;
    @Column(name="type_scale")
    private Integer typeScale;
    @Column(name="type_interval_type")
    private String typeIntervalType;
    @Column(name="nullable", nullable=false)
    private boolean nullable;
    @Column(name="comment", length=65535)
    private String comment;
    @Column(name="partition_index")
    private Short partitionIndex;

    public static ColumnInfoDAO from(ColumnInfo column) {
        if (column == null) {
            return null;
        }
        return ((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)((ColumnInfoDAOBuilder)ColumnInfoDAO.builder().name(column.getName())).typeText(column.getTypeText())).typeJson(column.getTypeJson())).typeName(column.getTypeName().toString())).typePrecision(column.getTypePrecision())).typeScale(column.getTypeScale())).typeIntervalType(column.getTypeIntervalType())).ordinalPosition(column.getPosition().shortValue())).comment(column.getComment())).nullable(Optional.ofNullable(column.getNullable()).orElse(false))).partitionIndex(column.getPartitionIndex() != null ? Short.valueOf(column.getPartitionIndex().shortValue()) : null)).build();
    }

    public ColumnInfo toColumnInfo() {
        return new ColumnInfo().name(this.getName()).typeText(this.typeText).typeJson(this.typeJson).typeName(ColumnTypeName.valueOf(this.typeName)).typePrecision(this.typePrecision).typeScale(this.typeScale).typeIntervalType(this.typeIntervalType).position(Integer.valueOf(this.ordinalPosition)).comment(this.comment).nullable(this.nullable).partitionIndex(this.partitionIndex != null ? Integer.valueOf(this.partitionIndex.intValue()) : null);
    }

    public static List<ColumnInfo> toList(List<ColumnInfoDAO> columnInfoDAOs) {
        if (columnInfoDAOs == null) {
            return new ArrayList<ColumnInfo>();
        }
        return columnInfoDAOs.stream().map(ColumnInfoDAO::toColumnInfo).collect(Collectors.toList());
    }

    public static List<ColumnInfoDAO> fromList(List<ColumnInfo> columnInfos) {
        if (columnInfos == null) {
            return new ArrayList<ColumnInfoDAO>();
        }
        return columnInfos.stream().map(ColumnInfoDAO::from).collect(Collectors.toList());
    }

    protected ColumnInfoDAO(ColumnInfoDAOBuilder<?, ?> b) {
        super(b);
        this.table = b.table;
        this.ordinalPosition = b.ordinalPosition;
        this.typeText = b.typeText;
        this.typeJson = b.typeJson;
        this.typeName = b.typeName;
        this.typePrecision = b.typePrecision;
        this.typeScale = b.typeScale;
        this.typeIntervalType = b.typeIntervalType;
        this.nullable = b.nullable;
        this.comment = b.comment;
        this.partitionIndex = b.partitionIndex;
    }

    public static ColumnInfoDAOBuilder<?, ?> builder() {
        return new ColumnInfoDAOBuilderImpl();
    }

    public TableInfoDAO getTable() {
        return this.table;
    }

    public short getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getTypeText() {
        return this.typeText;
    }

    public String getTypeJson() {
        return this.typeJson;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Integer getTypePrecision() {
        return this.typePrecision;
    }

    public Integer getTypeScale() {
        return this.typeScale;
    }

    public String getTypeIntervalType() {
        return this.typeIntervalType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getComment() {
        return this.comment;
    }

    public Short getPartitionIndex() {
        return this.partitionIndex;
    }

    public void setTable(TableInfoDAO table) {
        this.table = table;
    }

    public void setOrdinalPosition(short ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public void setTypeText(String typeText) {
        this.typeText = typeText;
    }

    public void setTypeJson(String typeJson) {
        this.typeJson = typeJson;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTypePrecision(Integer typePrecision) {
        this.typePrecision = typePrecision;
    }

    public void setTypeScale(Integer typeScale) {
        this.typeScale = typeScale;
    }

    public void setTypeIntervalType(String typeIntervalType) {
        this.typeIntervalType = typeIntervalType;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setPartitionIndex(Short partitionIndex) {
        this.partitionIndex = partitionIndex;
    }

    public ColumnInfoDAO() {
    }

    public ColumnInfoDAO(TableInfoDAO table, short ordinalPosition, String typeText, String typeJson, String typeName, Integer typePrecision, Integer typeScale, String typeIntervalType, boolean nullable, String comment, Short partitionIndex) {
        this.table = table;
        this.ordinalPosition = ordinalPosition;
        this.typeText = typeText;
        this.typeJson = typeJson;
        this.typeName = typeName;
        this.typePrecision = typePrecision;
        this.typeScale = typeScale;
        this.typeIntervalType = typeIntervalType;
        this.nullable = nullable;
        this.comment = comment;
        this.partitionIndex = partitionIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnInfoDAO)) {
            return false;
        }
        ColumnInfoDAO other = (ColumnInfoDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getOrdinalPosition() != other.getOrdinalPosition()) {
            return false;
        }
        if (this.isNullable() != other.isNullable()) {
            return false;
        }
        Integer this$typePrecision = this.getTypePrecision();
        Integer other$typePrecision = other.getTypePrecision();
        if (this$typePrecision == null ? other$typePrecision != null : !((Object)this$typePrecision).equals(other$typePrecision)) {
            return false;
        }
        Integer this$typeScale = this.getTypeScale();
        Integer other$typeScale = other.getTypeScale();
        if (this$typeScale == null ? other$typeScale != null : !((Object)this$typeScale).equals(other$typeScale)) {
            return false;
        }
        Short this$partitionIndex = this.getPartitionIndex();
        Short other$partitionIndex = other.getPartitionIndex();
        if (this$partitionIndex == null ? other$partitionIndex != null : !((Object)this$partitionIndex).equals(other$partitionIndex)) {
            return false;
        }
        TableInfoDAO this$table = this.getTable();
        TableInfoDAO other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        String this$typeText = this.getTypeText();
        String other$typeText = other.getTypeText();
        if (this$typeText == null ? other$typeText != null : !this$typeText.equals(other$typeText)) {
            return false;
        }
        String this$typeJson = this.getTypeJson();
        String other$typeJson = other.getTypeJson();
        if (this$typeJson == null ? other$typeJson != null : !this$typeJson.equals(other$typeJson)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$typeIntervalType = this.getTypeIntervalType();
        String other$typeIntervalType = other.getTypeIntervalType();
        if (this$typeIntervalType == null ? other$typeIntervalType != null : !this$typeIntervalType.equals(other$typeIntervalType)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnInfoDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getOrdinalPosition();
        result = result * 59 + (this.isNullable() ? 79 : 97);
        Integer $typePrecision = this.getTypePrecision();
        result = result * 59 + ($typePrecision == null ? 43 : ((Object)$typePrecision).hashCode());
        Integer $typeScale = this.getTypeScale();
        result = result * 59 + ($typeScale == null ? 43 : ((Object)$typeScale).hashCode());
        Short $partitionIndex = this.getPartitionIndex();
        result = result * 59 + ($partitionIndex == null ? 43 : ((Object)$partitionIndex).hashCode());
        TableInfoDAO $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        String $typeText = this.getTypeText();
        result = result * 59 + ($typeText == null ? 43 : $typeText.hashCode());
        String $typeJson = this.getTypeJson();
        result = result * 59 + ($typeJson == null ? 43 : $typeJson.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $typeIntervalType = this.getTypeIntervalType();
        result = result * 59 + ($typeIntervalType == null ? 43 : $typeIntervalType.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "ColumnInfoDAO(table=" + String.valueOf(this.getTable()) + ", ordinalPosition=" + this.getOrdinalPosition() + ", typeText=" + this.getTypeText() + ", typeJson=" + this.getTypeJson() + ", typeName=" + this.getTypeName() + ", typePrecision=" + this.getTypePrecision() + ", typeScale=" + this.getTypeScale() + ", typeIntervalType=" + this.getTypeIntervalType() + ", nullable=" + this.isNullable() + ", comment=" + this.getComment() + ", partitionIndex=" + this.getPartitionIndex() + ")";
    }

    public static abstract class ColumnInfoDAOBuilder<C extends ColumnInfoDAO, B extends ColumnInfoDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private TableInfoDAO table;
        private short ordinalPosition;
        private String typeText;
        private String typeJson;
        private String typeName;
        private Integer typePrecision;
        private Integer typeScale;
        private String typeIntervalType;
        private boolean nullable;
        private String comment;
        private Short partitionIndex;

        public B table(TableInfoDAO table) {
            this.table = table;
            return (B)this.self();
        }

        public B ordinalPosition(short ordinalPosition) {
            this.ordinalPosition = ordinalPosition;
            return (B)this.self();
        }

        public B typeText(String typeText) {
            this.typeText = typeText;
            return (B)this.self();
        }

        public B typeJson(String typeJson) {
            this.typeJson = typeJson;
            return (B)this.self();
        }

        public B typeName(String typeName) {
            this.typeName = typeName;
            return (B)this.self();
        }

        public B typePrecision(Integer typePrecision) {
            this.typePrecision = typePrecision;
            return (B)this.self();
        }

        public B typeScale(Integer typeScale) {
            this.typeScale = typeScale;
            return (B)this.self();
        }

        public B typeIntervalType(String typeIntervalType) {
            this.typeIntervalType = typeIntervalType;
            return (B)this.self();
        }

        public B nullable(boolean nullable) {
            this.nullable = nullable;
            return (B)this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        public B partitionIndex(Short partitionIndex) {
            this.partitionIndex = partitionIndex;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ColumnInfoDAO.ColumnInfoDAOBuilder(super=" + super.toString() + ", table=" + String.valueOf(this.table) + ", ordinalPosition=" + this.ordinalPosition + ", typeText=" + this.typeText + ", typeJson=" + this.typeJson + ", typeName=" + this.typeName + ", typePrecision=" + this.typePrecision + ", typeScale=" + this.typeScale + ", typeIntervalType=" + this.typeIntervalType + ", nullable=" + this.nullable + ", comment=" + this.comment + ", partitionIndex=" + this.partitionIndex + ")";
        }
    }

    private static final class ColumnInfoDAOBuilderImpl
    extends ColumnInfoDAOBuilder<ColumnInfoDAO, ColumnInfoDAOBuilderImpl> {
        private ColumnInfoDAOBuilderImpl() {
        }

        @Override
        protected ColumnInfoDAOBuilderImpl self() {
            return this;
        }

        @Override
        public ColumnInfoDAO build() {
            return new ColumnInfoDAO(this);
        }
    }
}

