/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.unitycatalog.server.model.AwsIamRoleResponse;
import io.unitycatalog.server.model.CredentialInfo;
import io.unitycatalog.server.model.CredentialPurpose;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;

@Entity
@Table(name="uc_credentials")
public class CredentialDAO
extends IdentifiableDAO {
    public static ObjectMapper objectMapper = new ObjectMapper();
    @Column(name="credential_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private CredentialType credentialType;
    @Lob
    @Column(name="credential", nullable=false)
    private String credential;
    @Column(name="purpose", nullable=false)
    private CredentialPurpose purpose;
    @Column(name="comment")
    private String comment;
    @Column(name="owner")
    private String owner;
    @Column(name="created_at", nullable=false)
    private Date createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Date updatedAt;
    @Column(name="updated_by")
    private String updatedBy;

    public static CredentialDAO from(CredentialInfo credentialInfo) {
        Object credentialDAOBuilder = ((CredentialDAOBuilder)((CredentialDAOBuilder)((CredentialDAOBuilder)((CredentialDAOBuilder)((CredentialDAOBuilder)((CredentialDAOBuilder)((CredentialDAOBuilder)((CredentialDAOBuilder)CredentialDAO.builder().id(credentialInfo.getId() != null ? UUID.fromString(credentialInfo.getId()) : null)).name(credentialInfo.getName())).purpose(credentialInfo.getPurpose())).comment(credentialInfo.getComment())).owner(credentialInfo.getOwner())).createdAt(credentialInfo.getCreatedAt() != null ? Date.from(Instant.ofEpochMilli(credentialInfo.getCreatedAt())) : new Date())).createdBy(credentialInfo.getCreatedBy())).updatedAt(credentialInfo.getUpdatedAt() != null ? Date.from(Instant.ofEpochMilli(credentialInfo.getUpdatedAt())) : null)).updatedBy(credentialInfo.getUpdatedBy());
        try {
            if (credentialInfo.getAwsIamRole() == null) {
                throw new IllegalArgumentException("Unknown credential type");
            }
            ((CredentialDAOBuilder)credentialDAOBuilder).credentialType(CredentialType.AWS_IAM_ROLE);
            String jsonCredential = objectMapper.writeValueAsString((Object)credentialInfo.getAwsIamRole());
            ((CredentialDAOBuilder)credentialDAOBuilder).credential(jsonCredential);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize credential", e);
        }
        return ((CredentialDAOBuilder)credentialDAOBuilder).build();
    }

    public CredentialInfo toCredentialInfo() {
        CredentialInfo credentialInfo = new CredentialInfo().id(this.getId().toString()).name(this.getName()).purpose(this.getPurpose()).comment(this.getComment()).owner(this.getOwner()).createdAt(this.getCreatedAt().getTime()).createdBy(this.getCreatedBy()).updatedAt(this.getUpdatedAt() != null ? Long.valueOf(this.getUpdatedAt().getTime()) : null).updatedBy(this.getUpdatedBy());
        try {
            switch (this.getCredentialType()) {
                case AWS_IAM_ROLE: {
                    credentialInfo.setAwsIamRole((AwsIamRoleResponse)objectMapper.readValue(this.getCredential(), AwsIamRoleResponse.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown credential type");
                }
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to parse credential", e);
        }
        return credentialInfo;
    }

    protected CredentialDAO(CredentialDAOBuilder<?, ?> b) {
        super(b);
        this.credentialType = b.credentialType;
        this.credential = b.credential;
        this.purpose = b.purpose;
        this.comment = b.comment;
        this.owner = b.owner;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
    }

    public static CredentialDAOBuilder<?, ?> builder() {
        return new CredentialDAOBuilderImpl();
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public String getCredential() {
        return this.credential;
    }

    public CredentialPurpose getPurpose() {
        return this.purpose;
    }

    public String getComment() {
        return this.comment;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public void setPurpose(CredentialPurpose purpose) {
        this.purpose = purpose;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public CredentialDAO(CredentialType credentialType, String credential, CredentialPurpose purpose, String comment, String owner, Date createdAt, String createdBy, Date updatedAt, String updatedBy) {
        this.credentialType = credentialType;
        this.credential = credential;
        this.purpose = purpose;
        this.comment = comment;
        this.owner = owner;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
    }

    public CredentialDAO() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CredentialDAO)) {
            return false;
        }
        CredentialDAO other = (CredentialDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CredentialType this$credentialType = this.getCredentialType();
        CredentialType other$credentialType = other.getCredentialType();
        if (this$credentialType == null ? other$credentialType != null : !((Object)((Object)this$credentialType)).equals((Object)other$credentialType)) {
            return false;
        }
        String this$credential = this.getCredential();
        String other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !this$credential.equals(other$credential)) {
            return false;
        }
        CredentialPurpose this$purpose = this.getPurpose();
        CredentialPurpose other$purpose = other.getPurpose();
        if (this$purpose == null ? other$purpose != null : !((Object)((Object)this$purpose)).equals((Object)other$purpose)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        return !(this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CredentialDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CredentialType $credentialType = this.getCredentialType();
        result = result * 59 + ($credentialType == null ? 43 : ((Object)((Object)$credentialType)).hashCode());
        String $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
        CredentialPurpose $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 43 : ((Object)((Object)$purpose)).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        return result;
    }

    public static abstract class CredentialDAOBuilder<C extends CredentialDAO, B extends CredentialDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private CredentialType credentialType;
        private String credential;
        private CredentialPurpose purpose;
        private String comment;
        private String owner;
        private Date createdAt;
        private String createdBy;
        private Date updatedAt;
        private String updatedBy;

        public B credentialType(CredentialType credentialType) {
            this.credentialType = credentialType;
            return (B)this.self();
        }

        public B credential(String credential) {
            this.credential = credential;
            return (B)this.self();
        }

        public B purpose(CredentialPurpose purpose) {
            this.purpose = purpose;
            return (B)this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        public B owner(String owner) {
            this.owner = owner;
            return (B)this.self();
        }

        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "CredentialDAO.CredentialDAOBuilder(super=" + super.toString() + ", credentialType=" + String.valueOf((Object)this.credentialType) + ", credential=" + this.credential + ", purpose=" + String.valueOf((Object)this.purpose) + ", comment=" + this.comment + ", owner=" + this.owner + ", createdAt=" + String.valueOf(this.createdAt) + ", createdBy=" + this.createdBy + ", updatedAt=" + String.valueOf(this.updatedAt) + ", updatedBy=" + this.updatedBy + ")";
        }
    }

    public static enum CredentialType {
        AWS_IAM_ROLE;

    }

    private static final class CredentialDAOBuilderImpl
    extends CredentialDAOBuilder<CredentialDAO, CredentialDAOBuilderImpl> {
        private CredentialDAOBuilderImpl() {
        }

        @Override
        protected CredentialDAOBuilderImpl self() {
            return this;
        }

        @Override
        public CredentialDAO build() {
            return new CredentialDAO(this);
        }
    }
}

