/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.model.ExternalLocationInfo;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;

@Entity
@Table(name="uc_external_locations")
public class ExternalLocationDAO
extends IdentifiableDAO {
    @Column(name="url", nullable=false)
    private String url;
    @Column(name="comment")
    private String comment;
    @Column(name="owner")
    private String owner;
    @Column(name="credential_id", nullable=false)
    private UUID credentialId;
    @Column(name="created_at")
    private Date createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Date updatedAt;
    @Column(name="updated_by")
    private String updatedBy;

    public static ExternalLocationDAO from(ExternalLocationInfo externalLocationInfo) {
        return ((ExternalLocationDAOBuilder)((ExternalLocationDAOBuilder)((ExternalLocationDAOBuilder)((ExternalLocationDAOBuilder)((ExternalLocationDAOBuilder)((ExternalLocationDAOBuilder)((ExternalLocationDAOBuilder)((ExternalLocationDAOBuilder)((ExternalLocationDAOBuilder)ExternalLocationDAO.builder().name(externalLocationInfo.getName())).url(externalLocationInfo.getUrl())).comment(externalLocationInfo.getComment())).owner(externalLocationInfo.getOwner())).credentialId(externalLocationInfo.getCredentialId() != null ? UUID.fromString(externalLocationInfo.getCredentialId()) : null)).createdAt(externalLocationInfo.getCreatedAt() != null ? Date.from(Instant.ofEpochMilli(externalLocationInfo.getCreatedAt())) : new Date())).createdBy(externalLocationInfo.getCreatedBy())).updatedAt(externalLocationInfo.getUpdatedAt() != null ? Date.from(Instant.ofEpochMilli(externalLocationInfo.getUpdatedAt())) : null)).updatedBy(externalLocationInfo.getUpdatedBy())).build();
    }

    public ExternalLocationInfo toExternalLocationInfo() {
        return new ExternalLocationInfo().name(this.getName()).url(this.getUrl()).comment(this.getComment()).owner(this.getOwner()).credentialId(this.getCredentialId() != null ? this.getCredentialId().toString() : null).createdAt(this.getCreatedAt().getTime()).createdBy(this.getCreatedBy()).updatedAt(this.getUpdatedAt() != null ? Long.valueOf(this.getUpdatedAt().getTime()) : null).updatedBy(this.getUpdatedBy());
    }

    protected ExternalLocationDAO(ExternalLocationDAOBuilder<?, ?> b) {
        super(b);
        this.url = b.url;
        this.comment = b.comment;
        this.owner = b.owner;
        this.credentialId = b.credentialId;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
    }

    public static ExternalLocationDAOBuilder<?, ?> builder() {
        return new ExternalLocationDAOBuilderImpl();
    }

    public String getUrl() {
        return this.url;
    }

    public String getComment() {
        return this.comment;
    }

    public String getOwner() {
        return this.owner;
    }

    public UUID getCredentialId() {
        return this.credentialId;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCredentialId(UUID credentialId) {
        this.credentialId = credentialId;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public ExternalLocationDAO(String url, String comment, String owner, UUID credentialId, Date createdAt, String createdBy, Date updatedAt, String updatedBy) {
        this.url = url;
        this.comment = comment;
        this.owner = owner;
        this.credentialId = credentialId;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
    }

    public ExternalLocationDAO() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalLocationDAO)) {
            return false;
        }
        ExternalLocationDAO other = (ExternalLocationDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        UUID this$credentialId = this.getCredentialId();
        UUID other$credentialId = other.getCredentialId();
        if (this$credentialId == null ? other$credentialId != null : !((Object)this$credentialId).equals(other$credentialId)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        return !(this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalLocationDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        UUID $credentialId = this.getCredentialId();
        result = result * 59 + ($credentialId == null ? 43 : ((Object)$credentialId).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        return result;
    }

    public static abstract class ExternalLocationDAOBuilder<C extends ExternalLocationDAO, B extends ExternalLocationDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private String url;
        private String comment;
        private String owner;
        private UUID credentialId;
        private Date createdAt;
        private String createdBy;
        private Date updatedAt;
        private String updatedBy;

        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        public B owner(String owner) {
            this.owner = owner;
            return (B)this.self();
        }

        public B credentialId(UUID credentialId) {
            this.credentialId = credentialId;
            return (B)this.self();
        }

        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ExternalLocationDAO.ExternalLocationDAOBuilder(super=" + super.toString() + ", url=" + this.url + ", comment=" + this.comment + ", owner=" + this.owner + ", credentialId=" + String.valueOf(this.credentialId) + ", createdAt=" + String.valueOf(this.createdAt) + ", createdBy=" + this.createdBy + ", updatedAt=" + String.valueOf(this.updatedAt) + ", updatedBy=" + this.updatedBy + ")";
        }
    }

    private static final class ExternalLocationDAOBuilderImpl
    extends ExternalLocationDAOBuilder<ExternalLocationDAO, ExternalLocationDAOBuilderImpl> {
        private ExternalLocationDAOBuilderImpl() {
        }

        @Override
        protected ExternalLocationDAOBuilderImpl self() {
            return this;
        }

        @Override
        public ExternalLocationDAO build() {
            return new ExternalLocationDAO(this);
        }
    }
}

