/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.model.ColumnTypeName;
import io.unitycatalog.server.model.FunctionInfo;
import io.unitycatalog.server.persist.dao.FunctionParameterInfoDAO;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.List;
import java.util.UUID;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="uc_functions")
public class FunctionInfoDAO
extends IdentifiableDAO {
    @Column(name="schema_id")
    private UUID schemaId;
    @Column(name="comment", length=65535)
    private String comment;
    @Column(name="owner")
    private String owner;
    @Column(name="created_at")
    private Long createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Long updatedAt;
    @Column(name="updated_by")
    private String updatedBy;
    @Column(name="data_type")
    private ColumnTypeName dataType;
    @Column(name="full_data_type")
    private String fullDataType;
    @Column(name="external_language")
    private String externalLanguage;
    @Column(name="is_deterministic")
    private Boolean isDeterministic;
    @Column(name="is_null_call")
    private Boolean isNullCall;
    @Column(name="parameter_style")
    private FunctionInfo.ParameterStyleEnum parameterStyle;
    @Column(name="routine_body")
    private FunctionInfo.RoutineBodyEnum routineBody;
    @Lob
    @Column(name="routine_definition", length=0xFFFFFF)
    private String routineDefinition;
    @Column(name="sql_data_access")
    private FunctionInfo.SqlDataAccessEnum sqlDataAccess;
    @Column(name="security_type")
    private FunctionInfo.SecurityTypeEnum securityType;
    @Column(name="specific_name")
    private String specificName;
    @OneToMany(mappedBy="function", cascade={CascadeType.ALL}, orphanRemoval=true)
    @SQLRestriction(value="input_or_return = 0")
    private List<FunctionParameterInfoDAO> inputParams;
    @OneToMany(mappedBy="function", cascade={CascadeType.ALL}, orphanRemoval=true)
    @SQLRestriction(value="input_or_return = 1")
    private List<FunctionParameterInfoDAO> returnParams;

    public static FunctionInfoDAO from(FunctionInfo functionInfo) {
        IdentifiableDAO functionInfoDAO = ((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)((FunctionInfoDAOBuilder)FunctionInfoDAO.builder().id(functionInfo.getFunctionId() != null ? UUID.fromString(functionInfo.getFunctionId()) : null)).name(functionInfo.getName())).comment(functionInfo.getComment())).owner(functionInfo.getOwner())).createdAt(functionInfo.getCreatedAt())).createdBy(functionInfo.getCreatedBy())).updatedAt(functionInfo.getUpdatedAt())).updatedBy(functionInfo.getUpdatedBy())).dataType(functionInfo.getDataType())).fullDataType(functionInfo.getFullDataType())).externalLanguage(functionInfo.getExternalLanguage())).isDeterministic(functionInfo.getIsDeterministic())).isNullCall(functionInfo.getIsNullCall())).parameterStyle(functionInfo.getParameterStyle())).routineBody(functionInfo.getRoutineBody())).routineDefinition(functionInfo.getRoutineDefinition())).sqlDataAccess(functionInfo.getSqlDataAccess())).securityType(functionInfo.getSecurityType())).specificName(functionInfo.getSpecificName())).inputParams(FunctionParameterInfoDAO.from(functionInfo.getInputParams(), FunctionParameterInfoDAO.InputOrReturnEnum.INPUT))).returnParams(FunctionParameterInfoDAO.from(functionInfo.getReturnParams(), FunctionParameterInfoDAO.InputOrReturnEnum.RETURN))).build();
        for (FunctionParameterInfoDAO inputParam : ((FunctionInfoDAO)functionInfoDAO).inputParams) {
            inputParam.setFunction((FunctionInfoDAO)functionInfoDAO);
        }
        for (FunctionParameterInfoDAO returnParam : ((FunctionInfoDAO)functionInfoDAO).returnParams) {
            returnParam.setFunction((FunctionInfoDAO)functionInfoDAO);
        }
        return functionInfoDAO;
    }

    public FunctionInfo toFunctionInfo() {
        FunctionInfo functionInfo = new FunctionInfo().functionId(this.getId().toString()).name(this.getName()).comment(this.comment).owner(this.owner).createdAt(this.createdAt).createdBy(this.createdBy).updatedAt(this.updatedAt).updatedBy(this.updatedBy).dataType(this.dataType).fullDataType(this.fullDataType).externalLanguage(this.externalLanguage).isDeterministic(this.isDeterministic).isNullCall(this.isNullCall).parameterStyle(this.parameterStyle).routineBody(this.routineBody).routineDefinition(this.routineDefinition).sqlDataAccess(this.sqlDataAccess).securityType(this.securityType).specificName(this.specificName);
        if (!this.inputParams.isEmpty()) {
            functionInfo.inputParams(FunctionParameterInfoDAO.toFunctionParameterInfos(this.inputParams));
        }
        if (!this.returnParams.isEmpty()) {
            functionInfo.returnParams(FunctionParameterInfoDAO.toFunctionParameterInfos(this.returnParams));
        }
        return functionInfo;
    }

    protected FunctionInfoDAO(FunctionInfoDAOBuilder<?, ?> b) {
        super(b);
        this.schemaId = b.schemaId;
        this.comment = b.comment;
        this.owner = b.owner;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
        this.dataType = b.dataType;
        this.fullDataType = b.fullDataType;
        this.externalLanguage = b.externalLanguage;
        this.isDeterministic = b.isDeterministic;
        this.isNullCall = b.isNullCall;
        this.parameterStyle = b.parameterStyle;
        this.routineBody = b.routineBody;
        this.routineDefinition = b.routineDefinition;
        this.sqlDataAccess = b.sqlDataAccess;
        this.securityType = b.securityType;
        this.specificName = b.specificName;
        this.inputParams = b.inputParams;
        this.returnParams = b.returnParams;
    }

    public static FunctionInfoDAOBuilder<?, ?> builder() {
        return new FunctionInfoDAOBuilderImpl();
    }

    public UUID getSchemaId() {
        return this.schemaId;
    }

    public String getComment() {
        return this.comment;
    }

    public String getOwner() {
        return this.owner;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public ColumnTypeName getDataType() {
        return this.dataType;
    }

    public String getFullDataType() {
        return this.fullDataType;
    }

    public String getExternalLanguage() {
        return this.externalLanguage;
    }

    public Boolean getIsDeterministic() {
        return this.isDeterministic;
    }

    public Boolean getIsNullCall() {
        return this.isNullCall;
    }

    public FunctionInfo.ParameterStyleEnum getParameterStyle() {
        return this.parameterStyle;
    }

    public FunctionInfo.RoutineBodyEnum getRoutineBody() {
        return this.routineBody;
    }

    public String getRoutineDefinition() {
        return this.routineDefinition;
    }

    public FunctionInfo.SqlDataAccessEnum getSqlDataAccess() {
        return this.sqlDataAccess;
    }

    public FunctionInfo.SecurityTypeEnum getSecurityType() {
        return this.securityType;
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public List<FunctionParameterInfoDAO> getInputParams() {
        return this.inputParams;
    }

    public List<FunctionParameterInfoDAO> getReturnParams() {
        return this.returnParams;
    }

    public void setSchemaId(UUID schemaId) {
        this.schemaId = schemaId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setDataType(ColumnTypeName dataType) {
        this.dataType = dataType;
    }

    public void setFullDataType(String fullDataType) {
        this.fullDataType = fullDataType;
    }

    public void setExternalLanguage(String externalLanguage) {
        this.externalLanguage = externalLanguage;
    }

    public void setIsDeterministic(Boolean isDeterministic) {
        this.isDeterministic = isDeterministic;
    }

    public void setIsNullCall(Boolean isNullCall) {
        this.isNullCall = isNullCall;
    }

    public void setParameterStyle(FunctionInfo.ParameterStyleEnum parameterStyle) {
        this.parameterStyle = parameterStyle;
    }

    public void setRoutineBody(FunctionInfo.RoutineBodyEnum routineBody) {
        this.routineBody = routineBody;
    }

    public void setRoutineDefinition(String routineDefinition) {
        this.routineDefinition = routineDefinition;
    }

    public void setSqlDataAccess(FunctionInfo.SqlDataAccessEnum sqlDataAccess) {
        this.sqlDataAccess = sqlDataAccess;
    }

    public void setSecurityType(FunctionInfo.SecurityTypeEnum securityType) {
        this.securityType = securityType;
    }

    public void setSpecificName(String specificName) {
        this.specificName = specificName;
    }

    public void setInputParams(List<FunctionParameterInfoDAO> inputParams) {
        this.inputParams = inputParams;
    }

    public void setReturnParams(List<FunctionParameterInfoDAO> returnParams) {
        this.returnParams = returnParams;
    }

    public FunctionInfoDAO() {
    }

    public FunctionInfoDAO(UUID schemaId, String comment, String owner, Long createdAt, String createdBy, Long updatedAt, String updatedBy, ColumnTypeName dataType, String fullDataType, String externalLanguage, Boolean isDeterministic, Boolean isNullCall, FunctionInfo.ParameterStyleEnum parameterStyle, FunctionInfo.RoutineBodyEnum routineBody, String routineDefinition, FunctionInfo.SqlDataAccessEnum sqlDataAccess, FunctionInfo.SecurityTypeEnum securityType, String specificName, List<FunctionParameterInfoDAO> inputParams, List<FunctionParameterInfoDAO> returnParams) {
        this.schemaId = schemaId;
        this.comment = comment;
        this.owner = owner;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
        this.dataType = dataType;
        this.fullDataType = fullDataType;
        this.externalLanguage = externalLanguage;
        this.isDeterministic = isDeterministic;
        this.isNullCall = isNullCall;
        this.parameterStyle = parameterStyle;
        this.routineBody = routineBody;
        this.routineDefinition = routineDefinition;
        this.sqlDataAccess = sqlDataAccess;
        this.securityType = securityType;
        this.specificName = specificName;
        this.inputParams = inputParams;
        this.returnParams = returnParams;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionInfoDAO)) {
            return false;
        }
        FunctionInfoDAO other = (FunctionInfoDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$createdAt = this.getCreatedAt();
        Long other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Long this$updatedAt = this.getUpdatedAt();
        Long other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Boolean this$isDeterministic = this.getIsDeterministic();
        Boolean other$isDeterministic = other.getIsDeterministic();
        if (this$isDeterministic == null ? other$isDeterministic != null : !((Object)this$isDeterministic).equals(other$isDeterministic)) {
            return false;
        }
        Boolean this$isNullCall = this.getIsNullCall();
        Boolean other$isNullCall = other.getIsNullCall();
        if (this$isNullCall == null ? other$isNullCall != null : !((Object)this$isNullCall).equals(other$isNullCall)) {
            return false;
        }
        UUID this$schemaId = this.getSchemaId();
        UUID other$schemaId = other.getSchemaId();
        if (this$schemaId == null ? other$schemaId != null : !((Object)this$schemaId).equals(other$schemaId)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        ColumnTypeName this$dataType = this.getDataType();
        ColumnTypeName other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType)) {
            return false;
        }
        String this$fullDataType = this.getFullDataType();
        String other$fullDataType = other.getFullDataType();
        if (this$fullDataType == null ? other$fullDataType != null : !this$fullDataType.equals(other$fullDataType)) {
            return false;
        }
        String this$externalLanguage = this.getExternalLanguage();
        String other$externalLanguage = other.getExternalLanguage();
        if (this$externalLanguage == null ? other$externalLanguage != null : !this$externalLanguage.equals(other$externalLanguage)) {
            return false;
        }
        FunctionInfo.ParameterStyleEnum this$parameterStyle = this.getParameterStyle();
        FunctionInfo.ParameterStyleEnum other$parameterStyle = other.getParameterStyle();
        if (this$parameterStyle == null ? other$parameterStyle != null : !((Object)((Object)this$parameterStyle)).equals((Object)other$parameterStyle)) {
            return false;
        }
        FunctionInfo.RoutineBodyEnum this$routineBody = this.getRoutineBody();
        FunctionInfo.RoutineBodyEnum other$routineBody = other.getRoutineBody();
        if (this$routineBody == null ? other$routineBody != null : !((Object)((Object)this$routineBody)).equals((Object)other$routineBody)) {
            return false;
        }
        String this$routineDefinition = this.getRoutineDefinition();
        String other$routineDefinition = other.getRoutineDefinition();
        if (this$routineDefinition == null ? other$routineDefinition != null : !this$routineDefinition.equals(other$routineDefinition)) {
            return false;
        }
        FunctionInfo.SqlDataAccessEnum this$sqlDataAccess = this.getSqlDataAccess();
        FunctionInfo.SqlDataAccessEnum other$sqlDataAccess = other.getSqlDataAccess();
        if (this$sqlDataAccess == null ? other$sqlDataAccess != null : !((Object)((Object)this$sqlDataAccess)).equals((Object)other$sqlDataAccess)) {
            return false;
        }
        FunctionInfo.SecurityTypeEnum this$securityType = this.getSecurityType();
        FunctionInfo.SecurityTypeEnum other$securityType = other.getSecurityType();
        if (this$securityType == null ? other$securityType != null : !((Object)((Object)this$securityType)).equals((Object)other$securityType)) {
            return false;
        }
        String this$specificName = this.getSpecificName();
        String other$specificName = other.getSpecificName();
        if (this$specificName == null ? other$specificName != null : !this$specificName.equals(other$specificName)) {
            return false;
        }
        List<FunctionParameterInfoDAO> this$inputParams = this.getInputParams();
        List<FunctionParameterInfoDAO> other$inputParams = other.getInputParams();
        if (this$inputParams == null ? other$inputParams != null : !((Object)this$inputParams).equals(other$inputParams)) {
            return false;
        }
        List<FunctionParameterInfoDAO> this$returnParams = this.getReturnParams();
        List<FunctionParameterInfoDAO> other$returnParams = other.getReturnParams();
        return !(this$returnParams == null ? other$returnParams != null : !((Object)this$returnParams).equals(other$returnParams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionInfoDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Long $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Boolean $isDeterministic = this.getIsDeterministic();
        result = result * 59 + ($isDeterministic == null ? 43 : ((Object)$isDeterministic).hashCode());
        Boolean $isNullCall = this.getIsNullCall();
        result = result * 59 + ($isNullCall == null ? 43 : ((Object)$isNullCall).hashCode());
        UUID $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : ((Object)$schemaId).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        ColumnTypeName $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        String $fullDataType = this.getFullDataType();
        result = result * 59 + ($fullDataType == null ? 43 : $fullDataType.hashCode());
        String $externalLanguage = this.getExternalLanguage();
        result = result * 59 + ($externalLanguage == null ? 43 : $externalLanguage.hashCode());
        FunctionInfo.ParameterStyleEnum $parameterStyle = this.getParameterStyle();
        result = result * 59 + ($parameterStyle == null ? 43 : ((Object)((Object)$parameterStyle)).hashCode());
        FunctionInfo.RoutineBodyEnum $routineBody = this.getRoutineBody();
        result = result * 59 + ($routineBody == null ? 43 : ((Object)((Object)$routineBody)).hashCode());
        String $routineDefinition = this.getRoutineDefinition();
        result = result * 59 + ($routineDefinition == null ? 43 : $routineDefinition.hashCode());
        FunctionInfo.SqlDataAccessEnum $sqlDataAccess = this.getSqlDataAccess();
        result = result * 59 + ($sqlDataAccess == null ? 43 : ((Object)((Object)$sqlDataAccess)).hashCode());
        FunctionInfo.SecurityTypeEnum $securityType = this.getSecurityType();
        result = result * 59 + ($securityType == null ? 43 : ((Object)((Object)$securityType)).hashCode());
        String $specificName = this.getSpecificName();
        result = result * 59 + ($specificName == null ? 43 : $specificName.hashCode());
        List<FunctionParameterInfoDAO> $inputParams = this.getInputParams();
        result = result * 59 + ($inputParams == null ? 43 : ((Object)$inputParams).hashCode());
        List<FunctionParameterInfoDAO> $returnParams = this.getReturnParams();
        result = result * 59 + ($returnParams == null ? 43 : ((Object)$returnParams).hashCode());
        return result;
    }

    public static abstract class FunctionInfoDAOBuilder<C extends FunctionInfoDAO, B extends FunctionInfoDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private UUID schemaId;
        private String comment;
        private String owner;
        private Long createdAt;
        private String createdBy;
        private Long updatedAt;
        private String updatedBy;
        private ColumnTypeName dataType;
        private String fullDataType;
        private String externalLanguage;
        private Boolean isDeterministic;
        private Boolean isNullCall;
        private FunctionInfo.ParameterStyleEnum parameterStyle;
        private FunctionInfo.RoutineBodyEnum routineBody;
        private String routineDefinition;
        private FunctionInfo.SqlDataAccessEnum sqlDataAccess;
        private FunctionInfo.SecurityTypeEnum securityType;
        private String specificName;
        private List<FunctionParameterInfoDAO> inputParams;
        private List<FunctionParameterInfoDAO> returnParams;

        public B schemaId(UUID schemaId) {
            this.schemaId = schemaId;
            return (B)this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        public B owner(String owner) {
            this.owner = owner;
            return (B)this.self();
        }

        public B createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        public B updatedAt(Long updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        public B dataType(ColumnTypeName dataType) {
            this.dataType = dataType;
            return (B)this.self();
        }

        public B fullDataType(String fullDataType) {
            this.fullDataType = fullDataType;
            return (B)this.self();
        }

        public B externalLanguage(String externalLanguage) {
            this.externalLanguage = externalLanguage;
            return (B)this.self();
        }

        public B isDeterministic(Boolean isDeterministic) {
            this.isDeterministic = isDeterministic;
            return (B)this.self();
        }

        public B isNullCall(Boolean isNullCall) {
            this.isNullCall = isNullCall;
            return (B)this.self();
        }

        public B parameterStyle(FunctionInfo.ParameterStyleEnum parameterStyle) {
            this.parameterStyle = parameterStyle;
            return (B)this.self();
        }

        public B routineBody(FunctionInfo.RoutineBodyEnum routineBody) {
            this.routineBody = routineBody;
            return (B)this.self();
        }

        public B routineDefinition(String routineDefinition) {
            this.routineDefinition = routineDefinition;
            return (B)this.self();
        }

        public B sqlDataAccess(FunctionInfo.SqlDataAccessEnum sqlDataAccess) {
            this.sqlDataAccess = sqlDataAccess;
            return (B)this.self();
        }

        public B securityType(FunctionInfo.SecurityTypeEnum securityType) {
            this.securityType = securityType;
            return (B)this.self();
        }

        public B specificName(String specificName) {
            this.specificName = specificName;
            return (B)this.self();
        }

        public B inputParams(List<FunctionParameterInfoDAO> inputParams) {
            this.inputParams = inputParams;
            return (B)this.self();
        }

        public B returnParams(List<FunctionParameterInfoDAO> returnParams) {
            this.returnParams = returnParams;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "FunctionInfoDAO.FunctionInfoDAOBuilder(super=" + super.toString() + ", schemaId=" + String.valueOf(this.schemaId) + ", comment=" + this.comment + ", owner=" + this.owner + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", updatedAt=" + this.updatedAt + ", updatedBy=" + this.updatedBy + ", dataType=" + String.valueOf((Object)this.dataType) + ", fullDataType=" + this.fullDataType + ", externalLanguage=" + this.externalLanguage + ", isDeterministic=" + this.isDeterministic + ", isNullCall=" + this.isNullCall + ", parameterStyle=" + String.valueOf((Object)this.parameterStyle) + ", routineBody=" + String.valueOf((Object)this.routineBody) + ", routineDefinition=" + this.routineDefinition + ", sqlDataAccess=" + String.valueOf((Object)this.sqlDataAccess) + ", securityType=" + String.valueOf((Object)this.securityType) + ", specificName=" + this.specificName + ", inputParams=" + String.valueOf(this.inputParams) + ", returnParams=" + String.valueOf(this.returnParams) + ")";
        }
    }

    private static final class FunctionInfoDAOBuilderImpl
    extends FunctionInfoDAOBuilder<FunctionInfoDAO, FunctionInfoDAOBuilderImpl> {
        private FunctionInfoDAOBuilderImpl() {
        }

        @Override
        protected FunctionInfoDAOBuilderImpl self() {
            return this;
        }

        @Override
        public FunctionInfoDAO build() {
            return new FunctionInfoDAO(this);
        }
    }
}

