/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.model.ColumnTypeName;
import io.unitycatalog.server.model.FunctionParameterInfo;
import io.unitycatalog.server.model.FunctionParameterInfos;
import io.unitycatalog.server.model.FunctionParameterMode;
import io.unitycatalog.server.model.FunctionParameterType;
import io.unitycatalog.server.persist.dao.FunctionInfoDAO;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Entity
@Table(name="uc_function_params")
public class FunctionParameterInfoDAO
extends IdentifiableDAO {
    @ManyToOne
    @JoinColumn(name="function_id", referencedColumnName="id")
    private FunctionInfoDAO function;
    @Column(name="input_or_return", nullable=false)
    private InputOrReturnEnum inputOrReturn;
    @Column(name="type_text", nullable=false)
    private String typeText;
    @Column(name="type_json")
    private String typeJson;
    @Column(name="type_name", nullable=false)
    private ColumnTypeName typeName;
    @Column(name="type_precision")
    private Integer typePrecision;
    @Column(name="type_scale")
    private Integer typeScale;
    @Column(name="type_interval_type")
    private String typeIntervalType;
    @Column(name="position")
    private Integer position;
    @Column(name="parameter_mode")
    private FunctionParameterMode parameterMode;
    @Column(name="parameter_type")
    private FunctionParameterType parameterType;
    @Column(name="parameter_default")
    private String parameterDefault;
    @Column(name="comment")
    private String comment;

    public static FunctionParameterInfoDAO from(FunctionParameterInfo functionParameterInfo, InputOrReturnEnum inputOrReturn) {
        return ((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)((FunctionParameterInfoDAOBuilder)FunctionParameterInfoDAO.builder().name(functionParameterInfo.getName())).typeText(functionParameterInfo.getTypeText())).typeJson(functionParameterInfo.getTypeJson())).typeName(functionParameterInfo.getTypeName())).typePrecision(functionParameterInfo.getTypePrecision())).typeScale(functionParameterInfo.getTypeScale())).typeIntervalType(functionParameterInfo.getTypeIntervalType())).position(functionParameterInfo.getPosition())).parameterMode(functionParameterInfo.getParameterMode())).parameterType(functionParameterInfo.getParameterType())).parameterDefault(functionParameterInfo.getParameterDefault())).inputOrReturn(inputOrReturn)).comment(functionParameterInfo.getComment())).build();
    }

    public FunctionParameterInfo toFunctionParameterInfo() {
        return new FunctionParameterInfo().name(this.getName()).typeText(this.typeText).typeJson(this.typeJson).typeName(this.typeName).typePrecision(this.typePrecision).typeScale(this.typeScale).typeIntervalType(this.typeIntervalType).position(this.position).parameterMode(this.parameterMode).parameterType(this.parameterType).parameterDefault(this.parameterDefault).comment(this.comment);
    }

    public static List<FunctionParameterInfoDAO> from(FunctionParameterInfos functionParameterInfos, InputOrReturnEnum inputOrReturn) {
        if (functionParameterInfos == null || functionParameterInfos.getParameters() == null) {
            return new ArrayList<FunctionParameterInfoDAO>();
        }
        return functionParameterInfos.getParameters().stream().map(functionParameterInfo -> FunctionParameterInfoDAO.from(functionParameterInfo, inputOrReturn)).collect(Collectors.toList());
    }

    public static FunctionParameterInfos toFunctionParameterInfos(List<FunctionParameterInfoDAO> functionParameterInfoDAOs) {
        if (functionParameterInfoDAOs == null) {
            return null;
        }
        return new FunctionParameterInfos().parameters(functionParameterInfoDAOs.stream().map(FunctionParameterInfoDAO::toFunctionParameterInfo).collect(Collectors.toList()));
    }

    protected FunctionParameterInfoDAO(FunctionParameterInfoDAOBuilder<?, ?> b) {
        super(b);
        this.function = b.function;
        this.inputOrReturn = b.inputOrReturn;
        this.typeText = b.typeText;
        this.typeJson = b.typeJson;
        this.typeName = b.typeName;
        this.typePrecision = b.typePrecision;
        this.typeScale = b.typeScale;
        this.typeIntervalType = b.typeIntervalType;
        this.position = b.position;
        this.parameterMode = b.parameterMode;
        this.parameterType = b.parameterType;
        this.parameterDefault = b.parameterDefault;
        this.comment = b.comment;
    }

    public static FunctionParameterInfoDAOBuilder<?, ?> builder() {
        return new FunctionParameterInfoDAOBuilderImpl();
    }

    public FunctionInfoDAO getFunction() {
        return this.function;
    }

    public InputOrReturnEnum getInputOrReturn() {
        return this.inputOrReturn;
    }

    public String getTypeText() {
        return this.typeText;
    }

    public String getTypeJson() {
        return this.typeJson;
    }

    public ColumnTypeName getTypeName() {
        return this.typeName;
    }

    public Integer getTypePrecision() {
        return this.typePrecision;
    }

    public Integer getTypeScale() {
        return this.typeScale;
    }

    public String getTypeIntervalType() {
        return this.typeIntervalType;
    }

    public Integer getPosition() {
        return this.position;
    }

    public FunctionParameterMode getParameterMode() {
        return this.parameterMode;
    }

    public FunctionParameterType getParameterType() {
        return this.parameterType;
    }

    public String getParameterDefault() {
        return this.parameterDefault;
    }

    public String getComment() {
        return this.comment;
    }

    public void setFunction(FunctionInfoDAO function) {
        this.function = function;
    }

    public void setInputOrReturn(InputOrReturnEnum inputOrReturn) {
        this.inputOrReturn = inputOrReturn;
    }

    public void setTypeText(String typeText) {
        this.typeText = typeText;
    }

    public void setTypeJson(String typeJson) {
        this.typeJson = typeJson;
    }

    public void setTypeName(ColumnTypeName typeName) {
        this.typeName = typeName;
    }

    public void setTypePrecision(Integer typePrecision) {
        this.typePrecision = typePrecision;
    }

    public void setTypeScale(Integer typeScale) {
        this.typeScale = typeScale;
    }

    public void setTypeIntervalType(String typeIntervalType) {
        this.typeIntervalType = typeIntervalType;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    public void setParameterMode(FunctionParameterMode parameterMode) {
        this.parameterMode = parameterMode;
    }

    public void setParameterType(FunctionParameterType parameterType) {
        this.parameterType = parameterType;
    }

    public void setParameterDefault(String parameterDefault) {
        this.parameterDefault = parameterDefault;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public FunctionParameterInfoDAO() {
    }

    public FunctionParameterInfoDAO(FunctionInfoDAO function, InputOrReturnEnum inputOrReturn, String typeText, String typeJson, ColumnTypeName typeName, Integer typePrecision, Integer typeScale, String typeIntervalType, Integer position, FunctionParameterMode parameterMode, FunctionParameterType parameterType, String parameterDefault, String comment) {
        this.function = function;
        this.inputOrReturn = inputOrReturn;
        this.typeText = typeText;
        this.typeJson = typeJson;
        this.typeName = typeName;
        this.typePrecision = typePrecision;
        this.typeScale = typeScale;
        this.typeIntervalType = typeIntervalType;
        this.position = position;
        this.parameterMode = parameterMode;
        this.parameterType = parameterType;
        this.parameterDefault = parameterDefault;
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionParameterInfoDAO)) {
            return false;
        }
        FunctionParameterInfoDAO other = (FunctionParameterInfoDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$typePrecision = this.getTypePrecision();
        Integer other$typePrecision = other.getTypePrecision();
        if (this$typePrecision == null ? other$typePrecision != null : !((Object)this$typePrecision).equals(other$typePrecision)) {
            return false;
        }
        Integer this$typeScale = this.getTypeScale();
        Integer other$typeScale = other.getTypeScale();
        if (this$typeScale == null ? other$typeScale != null : !((Object)this$typeScale).equals(other$typeScale)) {
            return false;
        }
        Integer this$position = this.getPosition();
        Integer other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        FunctionInfoDAO this$function = this.getFunction();
        FunctionInfoDAO other$function = other.getFunction();
        if (this$function == null ? other$function != null : !((Object)this$function).equals(other$function)) {
            return false;
        }
        InputOrReturnEnum this$inputOrReturn = this.getInputOrReturn();
        InputOrReturnEnum other$inputOrReturn = other.getInputOrReturn();
        if (this$inputOrReturn == null ? other$inputOrReturn != null : !((Object)((Object)this$inputOrReturn)).equals((Object)other$inputOrReturn)) {
            return false;
        }
        String this$typeText = this.getTypeText();
        String other$typeText = other.getTypeText();
        if (this$typeText == null ? other$typeText != null : !this$typeText.equals(other$typeText)) {
            return false;
        }
        String this$typeJson = this.getTypeJson();
        String other$typeJson = other.getTypeJson();
        if (this$typeJson == null ? other$typeJson != null : !this$typeJson.equals(other$typeJson)) {
            return false;
        }
        ColumnTypeName this$typeName = this.getTypeName();
        ColumnTypeName other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !((Object)((Object)this$typeName)).equals((Object)other$typeName)) {
            return false;
        }
        String this$typeIntervalType = this.getTypeIntervalType();
        String other$typeIntervalType = other.getTypeIntervalType();
        if (this$typeIntervalType == null ? other$typeIntervalType != null : !this$typeIntervalType.equals(other$typeIntervalType)) {
            return false;
        }
        FunctionParameterMode this$parameterMode = this.getParameterMode();
        FunctionParameterMode other$parameterMode = other.getParameterMode();
        if (this$parameterMode == null ? other$parameterMode != null : !((Object)((Object)this$parameterMode)).equals((Object)other$parameterMode)) {
            return false;
        }
        FunctionParameterType this$parameterType = this.getParameterType();
        FunctionParameterType other$parameterType = other.getParameterType();
        if (this$parameterType == null ? other$parameterType != null : !((Object)((Object)this$parameterType)).equals((Object)other$parameterType)) {
            return false;
        }
        String this$parameterDefault = this.getParameterDefault();
        String other$parameterDefault = other.getParameterDefault();
        if (this$parameterDefault == null ? other$parameterDefault != null : !this$parameterDefault.equals(other$parameterDefault)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionParameterInfoDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $typePrecision = this.getTypePrecision();
        result = result * 59 + ($typePrecision == null ? 43 : ((Object)$typePrecision).hashCode());
        Integer $typeScale = this.getTypeScale();
        result = result * 59 + ($typeScale == null ? 43 : ((Object)$typeScale).hashCode());
        Integer $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        FunctionInfoDAO $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : ((Object)$function).hashCode());
        InputOrReturnEnum $inputOrReturn = this.getInputOrReturn();
        result = result * 59 + ($inputOrReturn == null ? 43 : ((Object)((Object)$inputOrReturn)).hashCode());
        String $typeText = this.getTypeText();
        result = result * 59 + ($typeText == null ? 43 : $typeText.hashCode());
        String $typeJson = this.getTypeJson();
        result = result * 59 + ($typeJson == null ? 43 : $typeJson.hashCode());
        ColumnTypeName $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : ((Object)((Object)$typeName)).hashCode());
        String $typeIntervalType = this.getTypeIntervalType();
        result = result * 59 + ($typeIntervalType == null ? 43 : $typeIntervalType.hashCode());
        FunctionParameterMode $parameterMode = this.getParameterMode();
        result = result * 59 + ($parameterMode == null ? 43 : ((Object)((Object)$parameterMode)).hashCode());
        FunctionParameterType $parameterType = this.getParameterType();
        result = result * 59 + ($parameterType == null ? 43 : ((Object)((Object)$parameterType)).hashCode());
        String $parameterDefault = this.getParameterDefault();
        result = result * 59 + ($parameterDefault == null ? 43 : $parameterDefault.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public static abstract class FunctionParameterInfoDAOBuilder<C extends FunctionParameterInfoDAO, B extends FunctionParameterInfoDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private FunctionInfoDAO function;
        private InputOrReturnEnum inputOrReturn;
        private String typeText;
        private String typeJson;
        private ColumnTypeName typeName;
        private Integer typePrecision;
        private Integer typeScale;
        private String typeIntervalType;
        private Integer position;
        private FunctionParameterMode parameterMode;
        private FunctionParameterType parameterType;
        private String parameterDefault;
        private String comment;

        public B function(FunctionInfoDAO function) {
            this.function = function;
            return (B)this.self();
        }

        public B inputOrReturn(InputOrReturnEnum inputOrReturn) {
            this.inputOrReturn = inputOrReturn;
            return (B)this.self();
        }

        public B typeText(String typeText) {
            this.typeText = typeText;
            return (B)this.self();
        }

        public B typeJson(String typeJson) {
            this.typeJson = typeJson;
            return (B)this.self();
        }

        public B typeName(ColumnTypeName typeName) {
            this.typeName = typeName;
            return (B)this.self();
        }

        public B typePrecision(Integer typePrecision) {
            this.typePrecision = typePrecision;
            return (B)this.self();
        }

        public B typeScale(Integer typeScale) {
            this.typeScale = typeScale;
            return (B)this.self();
        }

        public B typeIntervalType(String typeIntervalType) {
            this.typeIntervalType = typeIntervalType;
            return (B)this.self();
        }

        public B position(Integer position) {
            this.position = position;
            return (B)this.self();
        }

        public B parameterMode(FunctionParameterMode parameterMode) {
            this.parameterMode = parameterMode;
            return (B)this.self();
        }

        public B parameterType(FunctionParameterType parameterType) {
            this.parameterType = parameterType;
            return (B)this.self();
        }

        public B parameterDefault(String parameterDefault) {
            this.parameterDefault = parameterDefault;
            return (B)this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "FunctionParameterInfoDAO.FunctionParameterInfoDAOBuilder(super=" + super.toString() + ", function=" + String.valueOf(this.function) + ", inputOrReturn=" + String.valueOf((Object)this.inputOrReturn) + ", typeText=" + this.typeText + ", typeJson=" + this.typeJson + ", typeName=" + String.valueOf((Object)this.typeName) + ", typePrecision=" + this.typePrecision + ", typeScale=" + this.typeScale + ", typeIntervalType=" + this.typeIntervalType + ", position=" + this.position + ", parameterMode=" + String.valueOf((Object)this.parameterMode) + ", parameterType=" + String.valueOf((Object)this.parameterType) + ", parameterDefault=" + this.parameterDefault + ", comment=" + this.comment + ")";
        }
    }

    public static enum InputOrReturnEnum {
        INPUT,
        RETURN;

    }

    private static final class FunctionParameterInfoDAOBuilderImpl
    extends FunctionParameterInfoDAOBuilder<FunctionParameterInfoDAO, FunctionParameterInfoDAOBuilderImpl> {
        private FunctionParameterInfoDAOBuilderImpl() {
        }

        @Override
        protected FunctionParameterInfoDAOBuilderImpl self() {
            return this;
        }

        @Override
        public FunctionParameterInfoDAO build() {
            return new FunctionParameterInfoDAO(this);
        }
    }
}

