/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.persist.dao.FunctionInfoDAO;
import io.unitycatalog.server.persist.dao.RegisteredModelInfoDAO;
import io.unitycatalog.server.persist.dao.SchemaInfoDAO;
import io.unitycatalog.server.persist.dao.TableInfoDAO;
import io.unitycatalog.server.persist.dao.VolumeInfoDAO;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.util.Optional;
import java.util.UUID;

@MappedSuperclass
public class IdentifiableDAO {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="name", nullable=false)
    private String name;

    public static <T extends IdentifiableDAO> Optional<String> getParentIdColumnName(Class<T> entityClass) {
        if (TableInfoDAO.class == entityClass || VolumeInfoDAO.class == entityClass || FunctionInfoDAO.class == entityClass || RegisteredModelInfoDAO.class == entityClass) {
            return Optional.of("schemaId");
        }
        if (SchemaInfoDAO.class == entityClass) {
            return Optional.of("catalogId");
        }
        return Optional.empty();
    }

    protected IdentifiableDAO(IdentifiableDAOBuilder<?, ?> b) {
        this.id = b.id;
        this.name = b.name;
    }

    public static IdentifiableDAOBuilder<?, ?> builder() {
        return new IdentifiableDAOBuilderImpl();
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IdentifiableDAO() {
    }

    public IdentifiableDAO(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    public static abstract class IdentifiableDAOBuilder<C extends IdentifiableDAO, B extends IdentifiableDAOBuilder<C, B>> {
        private UUID id;
        private String name;

        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "IdentifiableDAO.IdentifiableDAOBuilder(id=" + String.valueOf(this.id) + ", name=" + this.name + ")";
        }
    }

    private static final class IdentifiableDAOBuilderImpl
    extends IdentifiableDAOBuilder<IdentifiableDAO, IdentifiableDAOBuilderImpl> {
        private IdentifiableDAOBuilderImpl() {
        }

        @Override
        protected IdentifiableDAOBuilderImpl self() {
            return this;
        }

        @Override
        public IdentifiableDAO build() {
            return new IdentifiableDAO(this);
        }
    }
}

