/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.model.ModelVersionInfo;
import io.unitycatalog.server.model.ModelVersionStatus;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.UUID;

@Entity
@Table(name="uc_model_versions", indexes={@Index(name="idx_model_version", columnList="registered_model_id,version")})
public class ModelVersionInfoDAO {
    @Id
    @Column(name="id")
    private UUID id;
    @Column(name="registered_model_id")
    private UUID registeredModelId;
    @Column(name="version")
    private Long version;
    @Column(name="source")
    private String source;
    @Column(name="run_id")
    private String runId;
    @Column(name="status")
    private String status;
    @Column(name="owner")
    private String owner;
    @Column(name="created_at")
    private Date createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Date updatedAt;
    @Column(name="updated_by")
    private String updatedBy;
    @Column(name="comment", length=65535)
    private String comment;
    @Column(name="url", length=4096)
    private String url;

    public static ModelVersionInfoDAO from(ModelVersionInfo modelVersionInfo) {
        return ((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)((ModelVersionInfoDAOBuilder)ModelVersionInfoDAO.builder().id(UUID.fromString(modelVersionInfo.getId()))).runId(modelVersionInfo.getRunId())).source(modelVersionInfo.getSource())).status(modelVersionInfo.getStatus().getValue())).comment(modelVersionInfo.getComment())).version(modelVersionInfo.getVersion())).createdAt(modelVersionInfo.getCreatedAt() != null ? new Date(modelVersionInfo.getCreatedAt()) : new Date())).createdBy(modelVersionInfo.getCreatedBy())).updatedAt(modelVersionInfo.getUpdatedAt() != null ? new Date(modelVersionInfo.getUpdatedAt()) : null)).updatedBy(modelVersionInfo.getUpdatedBy())).url(modelVersionInfo.getStorageLocation())).build();
    }

    public ModelVersionInfo toModelVersionInfo() {
        ModelVersionInfo modelVersionInfo = new ModelVersionInfo().id(this.getId().toString()).runId(this.getRunId()).source(this.getSource()).version(this.getVersion()).status(ModelVersionStatus.valueOf(this.getStatus())).storageLocation(this.url).comment(this.comment).createdAt(this.createdAt != null ? Long.valueOf(this.createdAt.getTime()) : null).createdBy(this.createdBy).updatedAt(this.updatedAt != null ? Long.valueOf(this.updatedAt.getTime()) : null).updatedBy(this.updatedBy);
        return modelVersionInfo;
    }

    protected ModelVersionInfoDAO(ModelVersionInfoDAOBuilder<?, ?> b) {
        this.id = b.id;
        this.registeredModelId = b.registeredModelId;
        this.version = b.version;
        this.source = b.source;
        this.runId = b.runId;
        this.status = b.status;
        this.owner = b.owner;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
        this.comment = b.comment;
        this.url = b.url;
    }

    public static ModelVersionInfoDAOBuilder<?, ?> builder() {
        return new ModelVersionInfoDAOBuilderImpl();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getRegisteredModelId() {
        return this.registeredModelId;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getSource() {
        return this.source;
    }

    public String getRunId() {
        return this.runId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getComment() {
        return this.comment;
    }

    public String getUrl() {
        return this.url;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setRegisteredModelId(UUID registeredModelId) {
        this.registeredModelId = registeredModelId;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setRunId(String runId) {
        this.runId = runId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ModelVersionInfoDAO() {
    }

    public ModelVersionInfoDAO(UUID id, UUID registeredModelId, Long version, String source, String runId, String status, String owner, Date createdAt, String createdBy, Date updatedAt, String updatedBy, String comment, String url) {
        this.id = id;
        this.registeredModelId = registeredModelId;
        this.version = version;
        this.source = source;
        this.runId = runId;
        this.status = status;
        this.owner = owner;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
        this.comment = comment;
        this.url = url;
    }

    public static abstract class ModelVersionInfoDAOBuilder<C extends ModelVersionInfoDAO, B extends ModelVersionInfoDAOBuilder<C, B>> {
        private UUID id;
        private UUID registeredModelId;
        private Long version;
        private String source;
        private String runId;
        private String status;
        private String owner;
        private Date createdAt;
        private String createdBy;
        private Date updatedAt;
        private String updatedBy;
        private String comment;
        private String url;

        public B id(UUID id) {
            this.id = id;
            return this.self();
        }

        public B registeredModelId(UUID registeredModelId) {
            this.registeredModelId = registeredModelId;
            return this.self();
        }

        public B version(Long version) {
            this.version = version;
            return this.self();
        }

        public B source(String source) {
            this.source = source;
            return this.self();
        }

        public B runId(String runId) {
            this.runId = runId;
            return this.self();
        }

        public B status(String status) {
            this.status = status;
            return this.self();
        }

        public B owner(String owner) {
            this.owner = owner;
            return this.self();
        }

        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this.self();
        }

        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return this.self();
        }

        public B url(String url) {
            this.url = url;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "ModelVersionInfoDAO.ModelVersionInfoDAOBuilder(id=" + String.valueOf(this.id) + ", registeredModelId=" + String.valueOf(this.registeredModelId) + ", version=" + this.version + ", source=" + this.source + ", runId=" + this.runId + ", status=" + this.status + ", owner=" + this.owner + ", createdAt=" + String.valueOf(this.createdAt) + ", createdBy=" + this.createdBy + ", updatedAt=" + String.valueOf(this.updatedAt) + ", updatedBy=" + this.updatedBy + ", comment=" + this.comment + ", url=" + this.url + ")";
        }
    }

    private static final class ModelVersionInfoDAOBuilderImpl
    extends ModelVersionInfoDAOBuilder<ModelVersionInfoDAO, ModelVersionInfoDAOBuilderImpl> {
        private ModelVersionInfoDAOBuilderImpl() {
        }

        @Override
        protected ModelVersionInfoDAOBuilderImpl self() {
            return this;
        }

        @Override
        public ModelVersionInfoDAO build() {
            return new ModelVersionInfoDAO(this);
        }
    }
}

