/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.UuidGenerator;

@Entity
@Table(name="uc_properties", uniqueConstraints={@UniqueConstraint(columnNames={"entity_id", "entity_type", "property_key"})})
public class PropertyDAO {
    @Id
    @UuidGenerator
    @Column(name="id", updatable=false, nullable=false)
    private UUID id;
    @Column(name="entity_id", nullable=false)
    private UUID entityId;
    @Column(name="entity_type", nullable=false)
    private String entityType;
    @Column(name="property_key", nullable=false)
    private String key;
    @Column(name="property_value", nullable=false)
    private String value;

    public static List<PropertyDAO> from(Map<String, String> properties, UUID entityId, String entityType) {
        if (properties == null) {
            return new ArrayList<PropertyDAO>();
        }
        return properties.entrySet().stream().map(entry -> PropertyDAO.builder().key((String)entry.getKey()).value((String)entry.getValue()).entityId(entityId).entityType(entityType).build()).collect(Collectors.toList());
    }

    public static Map<String, String> toMap(List<PropertyDAO> propertyDAOList) {
        return propertyDAOList.stream().collect(Collectors.toMap(PropertyDAO::getKey, PropertyDAO::getValue));
    }

    public static PropertyDAOBuilder builder() {
        return new PropertyDAOBuilder();
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setEntityId(UUID entityId) {
        this.entityId = entityId;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public PropertyDAO() {
    }

    public PropertyDAO(UUID id, UUID entityId, String entityType, String key, String value) {
        this.id = id;
        this.entityId = entityId;
        this.entityType = entityType;
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyDAO)) {
            return false;
        }
        PropertyDAO other = (PropertyDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$entityId = this.getEntityId();
        UUID other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !((Object)this$entityId).equals(other$entityId)) {
            return false;
        }
        String this$entityType = this.getEntityType();
        String other$entityType = other.getEntityType();
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : ((Object)$entityId).hashCode());
        String $entityType = this.getEntityType();
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "PropertyDAO(id=" + String.valueOf(this.getId()) + ", entityId=" + String.valueOf(this.getEntityId()) + ", entityType=" + this.getEntityType() + ", key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    public static class PropertyDAOBuilder {
        private UUID id;
        private UUID entityId;
        private String entityType;
        private String key;
        private String value;

        PropertyDAOBuilder() {
        }

        public PropertyDAOBuilder id(UUID id) {
            this.id = id;
            return this;
        }

        public PropertyDAOBuilder entityId(UUID entityId) {
            this.entityId = entityId;
            return this;
        }

        public PropertyDAOBuilder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public PropertyDAOBuilder key(String key) {
            this.key = key;
            return this;
        }

        public PropertyDAOBuilder value(String value) {
            this.value = value;
            return this;
        }

        public PropertyDAO build() {
            return new PropertyDAO(this.id, this.entityId, this.entityType, this.key, this.value);
        }

        public String toString() {
            return "PropertyDAO.PropertyDAOBuilder(id=" + String.valueOf(this.id) + ", entityId=" + String.valueOf(this.entityId) + ", entityType=" + this.entityType + ", key=" + this.key + ", value=" + this.value + ")";
        }
    }
}

