/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.model.RegisteredModelInfo;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.UUID;

@Entity
@Table(name="uc_registered_models", indexes={@Index(name="uc_registered_models_name_idx", columnList="name")})
public class RegisteredModelInfoDAO
extends IdentifiableDAO {
    @Column(name="schema_id")
    private UUID schemaId;
    @Column(name="owner")
    private String owner;
    @Column(name="created_at")
    private Date createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Date updatedAt;
    @Column(name="updated_by")
    private String updatedBy;
    @Column(name="comment", length=65535)
    private String comment;
    @Column(name="url", length=4096)
    private String url;
    @Column(name="max_version_number")
    private Long maxVersionNumber;

    public static RegisteredModelInfoDAO from(RegisteredModelInfo registeredModelInfo) {
        return ((RegisteredModelInfoDAOBuilder)((RegisteredModelInfoDAOBuilder)((RegisteredModelInfoDAOBuilder)((RegisteredModelInfoDAOBuilder)((RegisteredModelInfoDAOBuilder)((RegisteredModelInfoDAOBuilder)((RegisteredModelInfoDAOBuilder)((RegisteredModelInfoDAOBuilder)((RegisteredModelInfoDAOBuilder)RegisteredModelInfoDAO.builder().id(UUID.fromString(registeredModelInfo.getId()))).name(registeredModelInfo.getName())).comment(registeredModelInfo.getComment())).owner(registeredModelInfo.getOwner())).createdAt(registeredModelInfo.getCreatedAt() != null ? new Date(registeredModelInfo.getCreatedAt()) : new Date())).createdBy(registeredModelInfo.getCreatedBy())).updatedAt(registeredModelInfo.getUpdatedAt() != null ? new Date(registeredModelInfo.getUpdatedAt()) : null)).updatedBy(registeredModelInfo.getUpdatedBy())).url(registeredModelInfo.getStorageLocation())).build();
    }

    public RegisteredModelInfo toRegisteredModelInfo() {
        RegisteredModelInfo registeredModelInfo = new RegisteredModelInfo().id(this.getId().toString()).name(this.getName()).storageLocation(this.url).comment(this.comment).owner(this.owner).createdAt(this.createdAt != null ? Long.valueOf(this.createdAt.getTime()) : null).createdBy(this.createdBy).updatedAt(this.updatedAt != null ? Long.valueOf(this.updatedAt.getTime()) : null).updatedBy(this.updatedBy);
        return registeredModelInfo;
    }

    protected RegisteredModelInfoDAO(RegisteredModelInfoDAOBuilder<?, ?> b) {
        super(b);
        this.schemaId = b.schemaId;
        this.owner = b.owner;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
        this.comment = b.comment;
        this.url = b.url;
        this.maxVersionNumber = b.maxVersionNumber;
    }

    public static RegisteredModelInfoDAOBuilder<?, ?> builder() {
        return new RegisteredModelInfoDAOBuilderImpl();
    }

    public UUID getSchemaId() {
        return this.schemaId;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getComment() {
        return this.comment;
    }

    public String getUrl() {
        return this.url;
    }

    public Long getMaxVersionNumber() {
        return this.maxVersionNumber;
    }

    public void setSchemaId(UUID schemaId) {
        this.schemaId = schemaId;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMaxVersionNumber(Long maxVersionNumber) {
        this.maxVersionNumber = maxVersionNumber;
    }

    public RegisteredModelInfoDAO() {
    }

    public RegisteredModelInfoDAO(UUID schemaId, String owner, Date createdAt, String createdBy, Date updatedAt, String updatedBy, String comment, String url, Long maxVersionNumber) {
        this.schemaId = schemaId;
        this.owner = owner;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
        this.comment = comment;
        this.url = url;
        this.maxVersionNumber = maxVersionNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredModelInfoDAO)) {
            return false;
        }
        RegisteredModelInfoDAO other = (RegisteredModelInfoDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$maxVersionNumber = this.getMaxVersionNumber();
        Long other$maxVersionNumber = other.getMaxVersionNumber();
        if (this$maxVersionNumber == null ? other$maxVersionNumber != null : !((Object)this$maxVersionNumber).equals(other$maxVersionNumber)) {
            return false;
        }
        UUID this$schemaId = this.getSchemaId();
        UUID other$schemaId = other.getSchemaId();
        if (this$schemaId == null ? other$schemaId != null : !((Object)this$schemaId).equals(other$schemaId)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisteredModelInfoDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $maxVersionNumber = this.getMaxVersionNumber();
        result = result * 59 + ($maxVersionNumber == null ? 43 : ((Object)$maxVersionNumber).hashCode());
        UUID $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : ((Object)$schemaId).hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public static abstract class RegisteredModelInfoDAOBuilder<C extends RegisteredModelInfoDAO, B extends RegisteredModelInfoDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private UUID schemaId;
        private String owner;
        private Date createdAt;
        private String createdBy;
        private Date updatedAt;
        private String updatedBy;
        private String comment;
        private String url;
        private Long maxVersionNumber;

        public B schemaId(UUID schemaId) {
            this.schemaId = schemaId;
            return (B)this.self();
        }

        public B owner(String owner) {
            this.owner = owner;
            return (B)this.self();
        }

        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        public B maxVersionNumber(Long maxVersionNumber) {
            this.maxVersionNumber = maxVersionNumber;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "RegisteredModelInfoDAO.RegisteredModelInfoDAOBuilder(super=" + super.toString() + ", schemaId=" + String.valueOf(this.schemaId) + ", owner=" + this.owner + ", createdAt=" + String.valueOf(this.createdAt) + ", createdBy=" + this.createdBy + ", updatedAt=" + String.valueOf(this.updatedAt) + ", updatedBy=" + this.updatedBy + ", comment=" + this.comment + ", url=" + this.url + ", maxVersionNumber=" + this.maxVersionNumber + ")";
        }
    }

    private static final class RegisteredModelInfoDAOBuilderImpl
    extends RegisteredModelInfoDAOBuilder<RegisteredModelInfoDAO, RegisteredModelInfoDAOBuilderImpl> {
        private RegisteredModelInfoDAOBuilderImpl() {
        }

        @Override
        protected RegisteredModelInfoDAOBuilderImpl self() {
            return this;
        }

        @Override
        public RegisteredModelInfoDAO build() {
            return new RegisteredModelInfoDAO(this);
        }
    }
}

