/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.model.DataSourceFormat;
import io.unitycatalog.server.model.TableInfo;
import io.unitycatalog.server.model.TableType;
import io.unitycatalog.server.persist.dao.ColumnInfoDAO;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import io.unitycatalog.server.persist.utils.FileOperations;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Index;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Entity
@Table(name="uc_tables", indexes={@Index(name="idx_name", columnList="name")})
public class TableInfoDAO
extends IdentifiableDAO {
    @Column(name="schema_id")
    private UUID schemaId;
    @Column(name="type")
    private String type;
    @Column(name="owner")
    private String owner;
    @Column(name="created_at")
    private Date createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Date updatedAt;
    @Column(name="updated_by")
    private String updatedBy;
    @Column(name="data_source_format")
    private String dataSourceFormat;
    @Column(name="comment", length=65535)
    private String comment;
    @Column(name="url", length=2048)
    private String url;
    @Column(name="column_count")
    private Integer columnCount;
    @OneToMany(mappedBy="table", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    private List<ColumnInfoDAO> columns;
    @Column(name="uniform_iceberg_metadata_location", length=65535)
    private String uniformIcebergMetadataLocation;

    public static TableInfoDAO from(TableInfo tableInfo) {
        return ((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)((TableInfoDAOBuilder)TableInfoDAO.builder().id(UUID.fromString(tableInfo.getTableId()))).name(tableInfo.getName())).comment(tableInfo.getComment())).owner(tableInfo.getOwner())).createdAt(tableInfo.getCreatedAt() != null ? new Date(tableInfo.getCreatedAt()) : new Date())).createdBy(tableInfo.getCreatedBy())).updatedAt(tableInfo.getUpdatedAt() != null ? new Date(tableInfo.getUpdatedAt()) : null)).updatedBy(tableInfo.getUpdatedBy())).columnCount(tableInfo.getColumns() != null ? tableInfo.getColumns().size() : 0)).url(tableInfo.getStorageLocation() != null ? tableInfo.getStorageLocation() : null)).type(tableInfo.getTableType().toString())).dataSourceFormat(tableInfo.getDataSourceFormat().toString())).url(tableInfo.getStorageLocation())).columns(ColumnInfoDAO.fromList(tableInfo.getColumns()))).build();
    }

    public TableInfo toTableInfo(boolean fetchColumns) {
        TableInfo tableInfo = new TableInfo().tableId(this.getId().toString()).name(this.getName()).tableType(TableType.valueOf(this.type)).dataSourceFormat(DataSourceFormat.valueOf(this.dataSourceFormat)).storageLocation(FileOperations.convertRelativePathToURI(this.url)).comment(this.comment).owner(this.owner).createdAt(this.createdAt != null ? Long.valueOf(this.createdAt.getTime()) : null).createdBy(this.createdBy).updatedAt(this.updatedAt != null ? Long.valueOf(this.updatedAt.getTime()) : null).updatedBy(this.updatedBy);
        if (fetchColumns) {
            tableInfo.columns(ColumnInfoDAO.toList(this.columns));
        }
        return tableInfo;
    }

    protected TableInfoDAO(TableInfoDAOBuilder<?, ?> b) {
        super(b);
        this.schemaId = b.schemaId;
        this.type = b.type;
        this.owner = b.owner;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
        this.dataSourceFormat = b.dataSourceFormat;
        this.comment = b.comment;
        this.url = b.url;
        this.columnCount = b.columnCount;
        this.columns = b.columns;
        this.uniformIcebergMetadataLocation = b.uniformIcebergMetadataLocation;
    }

    public static TableInfoDAOBuilder<?, ?> builder() {
        return new TableInfoDAOBuilderImpl();
    }

    public UUID getSchemaId() {
        return this.schemaId;
    }

    public String getType() {
        return this.type;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getDataSourceFormat() {
        return this.dataSourceFormat;
    }

    public String getComment() {
        return this.comment;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getColumnCount() {
        return this.columnCount;
    }

    public List<ColumnInfoDAO> getColumns() {
        return this.columns;
    }

    public String getUniformIcebergMetadataLocation() {
        return this.uniformIcebergMetadataLocation;
    }

    public void setSchemaId(UUID schemaId) {
        this.schemaId = schemaId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setDataSourceFormat(String dataSourceFormat) {
        this.dataSourceFormat = dataSourceFormat;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setColumnCount(Integer columnCount) {
        this.columnCount = columnCount;
    }

    public void setColumns(List<ColumnInfoDAO> columns) {
        this.columns = columns;
    }

    public void setUniformIcebergMetadataLocation(String uniformIcebergMetadataLocation) {
        this.uniformIcebergMetadataLocation = uniformIcebergMetadataLocation;
    }

    public TableInfoDAO() {
    }

    public TableInfoDAO(UUID schemaId, String type, String owner, Date createdAt, String createdBy, Date updatedAt, String updatedBy, String dataSourceFormat, String comment, String url, Integer columnCount, List<ColumnInfoDAO> columns, String uniformIcebergMetadataLocation) {
        this.schemaId = schemaId;
        this.type = type;
        this.owner = owner;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
        this.dataSourceFormat = dataSourceFormat;
        this.comment = comment;
        this.url = url;
        this.columnCount = columnCount;
        this.columns = columns;
        this.uniformIcebergMetadataLocation = uniformIcebergMetadataLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableInfoDAO)) {
            return false;
        }
        TableInfoDAO other = (TableInfoDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$columnCount = this.getColumnCount();
        Integer other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !((Object)this$columnCount).equals(other$columnCount)) {
            return false;
        }
        UUID this$schemaId = this.getSchemaId();
        UUID other$schemaId = other.getSchemaId();
        if (this$schemaId == null ? other$schemaId != null : !((Object)this$schemaId).equals(other$schemaId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        String this$dataSourceFormat = this.getDataSourceFormat();
        String other$dataSourceFormat = other.getDataSourceFormat();
        if (this$dataSourceFormat == null ? other$dataSourceFormat != null : !this$dataSourceFormat.equals(other$dataSourceFormat)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<ColumnInfoDAO> this$columns = this.getColumns();
        List<ColumnInfoDAO> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$uniformIcebergMetadataLocation = this.getUniformIcebergMetadataLocation();
        String other$uniformIcebergMetadataLocation = other.getUniformIcebergMetadataLocation();
        return !(this$uniformIcebergMetadataLocation == null ? other$uniformIcebergMetadataLocation != null : !this$uniformIcebergMetadataLocation.equals(other$uniformIcebergMetadataLocation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableInfoDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $columnCount = this.getColumnCount();
        result = result * 59 + ($columnCount == null ? 43 : ((Object)$columnCount).hashCode());
        UUID $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : ((Object)$schemaId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        String $dataSourceFormat = this.getDataSourceFormat();
        result = result * 59 + ($dataSourceFormat == null ? 43 : $dataSourceFormat.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<ColumnInfoDAO> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $uniformIcebergMetadataLocation = this.getUniformIcebergMetadataLocation();
        result = result * 59 + ($uniformIcebergMetadataLocation == null ? 43 : $uniformIcebergMetadataLocation.hashCode());
        return result;
    }

    public static abstract class TableInfoDAOBuilder<C extends TableInfoDAO, B extends TableInfoDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private UUID schemaId;
        private String type;
        private String owner;
        private Date createdAt;
        private String createdBy;
        private Date updatedAt;
        private String updatedBy;
        private String dataSourceFormat;
        private String comment;
        private String url;
        private Integer columnCount;
        private List<ColumnInfoDAO> columns;
        private String uniformIcebergMetadataLocation;

        public B schemaId(UUID schemaId) {
            this.schemaId = schemaId;
            return (B)this.self();
        }

        public B type(String type) {
            this.type = type;
            return (B)this.self();
        }

        public B owner(String owner) {
            this.owner = owner;
            return (B)this.self();
        }

        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        public B dataSourceFormat(String dataSourceFormat) {
            this.dataSourceFormat = dataSourceFormat;
            return (B)this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        public B columnCount(Integer columnCount) {
            this.columnCount = columnCount;
            return (B)this.self();
        }

        public B columns(List<ColumnInfoDAO> columns) {
            this.columns = columns;
            return (B)this.self();
        }

        public B uniformIcebergMetadataLocation(String uniformIcebergMetadataLocation) {
            this.uniformIcebergMetadataLocation = uniformIcebergMetadataLocation;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TableInfoDAO.TableInfoDAOBuilder(super=" + super.toString() + ", schemaId=" + String.valueOf(this.schemaId) + ", type=" + this.type + ", owner=" + this.owner + ", createdAt=" + String.valueOf(this.createdAt) + ", createdBy=" + this.createdBy + ", updatedAt=" + String.valueOf(this.updatedAt) + ", updatedBy=" + this.updatedBy + ", dataSourceFormat=" + this.dataSourceFormat + ", comment=" + this.comment + ", url=" + this.url + ", columnCount=" + this.columnCount + ", columns=" + String.valueOf(this.columns) + ", uniformIcebergMetadataLocation=" + this.uniformIcebergMetadataLocation + ")";
        }
    }

    private static final class TableInfoDAOBuilderImpl
    extends TableInfoDAOBuilder<TableInfoDAO, TableInfoDAOBuilderImpl> {
        private TableInfoDAOBuilderImpl() {
        }

        @Override
        protected TableInfoDAOBuilderImpl self() {
            return this;
        }

        @Override
        public TableInfoDAO build() {
            return new TableInfoDAO(this);
        }
    }
}

