/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.control.model.User;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.UUID;

@Entity
@Table(name="uc_users")
public class UserDAO
extends IdentifiableDAO {
    @Column(name="email")
    private String email;
    @Column(name="external_id")
    private String externalId;
    @Column(name="state")
    private String state;
    @Column(name="created_at")
    private Date createdAt;
    @Column(name="updated_at")
    private Date updatedAt;
    @Column(name="picture_url")
    private String pictureUrl;

    public static UserDAO from(User user) {
        return ((UserDAOBuilder)((UserDAOBuilder)((UserDAOBuilder)((UserDAOBuilder)((UserDAOBuilder)((UserDAOBuilder)((UserDAOBuilder)((UserDAOBuilder)UserDAO.builder().id(UUID.fromString(user.getId()))).name(user.getName())).email(user.getEmail())).externalId(user.getExternalId())).state(user.getState().name())).pictureUrl(user.getPictureUrl())).createdAt(new Date(user.getCreatedAt()))).updatedAt(user.getUpdatedAt() == null ? null : new Date(user.getUpdatedAt()))).build();
    }

    public User toUser() {
        return new User().id(this.getId().toString()).name(this.getName()).email(this.getEmail()).externalId(this.getExternalId()).state(User.StateEnum.fromValue(this.getState())).pictureUrl(this.getPictureUrl()).createdAt(this.getCreatedAt().getTime()).updatedAt(this.getUpdatedAt() == null ? null : Long.valueOf(this.getUpdatedAt().getTime()));
    }

    protected UserDAO(UserDAOBuilder<?, ?> b) {
        super(b);
        this.email = b.email;
        this.externalId = b.externalId;
        this.state = b.state;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.pictureUrl = b.pictureUrl;
    }

    public static UserDAOBuilder<?, ?> builder() {
        return new UserDAOBuilderImpl();
    }

    public String getEmail() {
        return this.email;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getState() {
        return this.state;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public UserDAO() {
    }

    public UserDAO(String email, String externalId, String state, Date createdAt, Date updatedAt, String pictureUrl) {
        this.email = email;
        this.externalId = externalId;
        this.state = state;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.pictureUrl = pictureUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserDAO)) {
            return false;
        }
        UserDAO other = (UserDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$pictureUrl = this.getPictureUrl();
        String other$pictureUrl = other.getPictureUrl();
        return !(this$pictureUrl == null ? other$pictureUrl != null : !this$pictureUrl.equals(other$pictureUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $pictureUrl = this.getPictureUrl();
        result = result * 59 + ($pictureUrl == null ? 43 : $pictureUrl.hashCode());
        return result;
    }

    public static abstract class UserDAOBuilder<C extends UserDAO, B extends UserDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private String email;
        private String externalId;
        private String state;
        private Date createdAt;
        private Date updatedAt;
        private String pictureUrl;

        public B email(String email) {
            this.email = email;
            return (B)this.self();
        }

        public B externalId(String externalId) {
            this.externalId = externalId;
            return (B)this.self();
        }

        public B state(String state) {
            this.state = state;
            return (B)this.self();
        }

        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        public B pictureUrl(String pictureUrl) {
            this.pictureUrl = pictureUrl;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "UserDAO.UserDAOBuilder(super=" + super.toString() + ", email=" + this.email + ", externalId=" + this.externalId + ", state=" + this.state + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedAt=" + String.valueOf(this.updatedAt) + ", pictureUrl=" + this.pictureUrl + ")";
        }
    }

    private static final class UserDAOBuilderImpl
    extends UserDAOBuilder<UserDAO, UserDAOBuilderImpl> {
        private UserDAOBuilderImpl() {
        }

        @Override
        protected UserDAOBuilderImpl self() {
            return this;
        }

        @Override
        public UserDAO build() {
            return new UserDAO(this);
        }
    }
}

