/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.dao;

import io.unitycatalog.server.model.VolumeInfo;
import io.unitycatalog.server.model.VolumeType;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import io.unitycatalog.server.persist.utils.FileOperations;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.Date;
import java.util.UUID;

@Entity
@Table(name="uc_volumes")
public class VolumeInfoDAO
extends IdentifiableDAO {
    @Column(name="schema_id")
    private UUID schemaId;
    @Column(name="comment")
    private String comment;
    @Column(name="storage_location")
    private String storageLocation;
    @Column(name="owner")
    private String owner;
    @Column(name="created_at")
    private Date createdAt;
    @Column(name="created_by")
    private String createdBy;
    @Column(name="updated_at")
    private Date updatedAt;
    @Column(name="updated_by")
    private String updatedBy;
    @Column(name="volume_type")
    private String volumeType;

    public VolumeInfo toVolumeInfo() {
        return new VolumeInfo().volumeId(this.getId().toString()).name(this.getName()).comment(this.comment).storageLocation(FileOperations.convertRelativePathToURI(this.storageLocation)).owner(this.owner).createdAt(this.createdAt.getTime()).createdBy(this.createdBy).updatedAt(this.updatedAt != null ? Long.valueOf(this.updatedAt.getTime()) : null).updatedBy(this.updatedBy).volumeType(VolumeType.valueOf(this.volumeType));
    }

    public static VolumeInfoDAO from(VolumeInfo volumeInfo) {
        if (volumeInfo == null) {
            return null;
        }
        return ((VolumeInfoDAOBuilder)((VolumeInfoDAOBuilder)((VolumeInfoDAOBuilder)((VolumeInfoDAOBuilder)((VolumeInfoDAOBuilder)((VolumeInfoDAOBuilder)((VolumeInfoDAOBuilder)((VolumeInfoDAOBuilder)((VolumeInfoDAOBuilder)((VolumeInfoDAOBuilder)VolumeInfoDAO.builder().id(UUID.fromString(volumeInfo.getVolumeId()))).name(volumeInfo.getName())).comment(volumeInfo.getComment())).storageLocation(volumeInfo.getStorageLocation())).owner(volumeInfo.getOwner())).createdAt(volumeInfo.getCreatedAt() != null ? new Date(volumeInfo.getCreatedAt()) : new Date())).createdBy(volumeInfo.getCreatedBy())).updatedAt(volumeInfo.getUpdatedAt() != null ? new Date(volumeInfo.getUpdatedAt()) : null)).updatedBy(volumeInfo.getUpdatedBy())).volumeType(volumeInfo.getVolumeType().getValue())).build();
    }

    protected VolumeInfoDAO(VolumeInfoDAOBuilder<?, ?> b) {
        super(b);
        this.schemaId = b.schemaId;
        this.comment = b.comment;
        this.storageLocation = b.storageLocation;
        this.owner = b.owner;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
        this.volumeType = b.volumeType;
    }

    public static VolumeInfoDAOBuilder<?, ?> builder() {
        return new VolumeInfoDAOBuilderImpl();
    }

    public UUID getSchemaId() {
        return this.schemaId;
    }

    public String getComment() {
        return this.comment;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public String getOwner() {
        return this.owner;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getVolumeType() {
        return this.volumeType;
    }

    public void setSchemaId(UUID schemaId) {
        this.schemaId = schemaId;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setVolumeType(String volumeType) {
        this.volumeType = volumeType;
    }

    public VolumeInfoDAO() {
    }

    public VolumeInfoDAO(UUID schemaId, String comment, String storageLocation, String owner, Date createdAt, String createdBy, Date updatedAt, String updatedBy, String volumeType) {
        this.schemaId = schemaId;
        this.comment = comment;
        this.storageLocation = storageLocation;
        this.owner = owner;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
        this.volumeType = volumeType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VolumeInfoDAO)) {
            return false;
        }
        VolumeInfoDAO other = (VolumeInfoDAO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$schemaId = this.getSchemaId();
        UUID other$schemaId = other.getSchemaId();
        if (this$schemaId == null ? other$schemaId != null : !((Object)this$schemaId).equals(other$schemaId)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$storageLocation = this.getStorageLocation();
        String other$storageLocation = other.getStorageLocation();
        if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        String this$volumeType = this.getVolumeType();
        String other$volumeType = other.getVolumeType();
        return !(this$volumeType == null ? other$volumeType != null : !this$volumeType.equals(other$volumeType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VolumeInfoDAO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : ((Object)$schemaId).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $storageLocation = this.getStorageLocation();
        result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        String $volumeType = this.getVolumeType();
        result = result * 59 + ($volumeType == null ? 43 : $volumeType.hashCode());
        return result;
    }

    public static abstract class VolumeInfoDAOBuilder<C extends VolumeInfoDAO, B extends VolumeInfoDAOBuilder<C, B>>
    extends IdentifiableDAO.IdentifiableDAOBuilder<C, B> {
        private UUID schemaId;
        private String comment;
        private String storageLocation;
        private String owner;
        private Date createdAt;
        private String createdBy;
        private Date updatedAt;
        private String updatedBy;
        private String volumeType;

        public B schemaId(UUID schemaId) {
            this.schemaId = schemaId;
            return (B)this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return (B)this.self();
        }

        public B storageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return (B)this.self();
        }

        public B owner(String owner) {
            this.owner = owner;
            return (B)this.self();
        }

        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        public B volumeType(String volumeType) {
            this.volumeType = volumeType;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "VolumeInfoDAO.VolumeInfoDAOBuilder(super=" + super.toString() + ", schemaId=" + String.valueOf(this.schemaId) + ", comment=" + this.comment + ", storageLocation=" + this.storageLocation + ", owner=" + this.owner + ", createdAt=" + String.valueOf(this.createdAt) + ", createdBy=" + this.createdBy + ", updatedAt=" + String.valueOf(this.updatedAt) + ", updatedBy=" + this.updatedBy + ", volumeType=" + this.volumeType + ")";
        }
    }

    private static final class VolumeInfoDAOBuilderImpl
    extends VolumeInfoDAOBuilder<VolumeInfoDAO, VolumeInfoDAOBuilderImpl> {
        private VolumeInfoDAOBuilderImpl() {
        }

        @Override
        protected VolumeInfoDAOBuilderImpl self() {
            return this;
        }

        @Override
        public VolumeInfoDAO build() {
            return new VolumeInfoDAO(this);
        }
    }
}

