/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.model;

import io.unitycatalog.server.model.Privilege;

public enum Privileges {
    OWNER("OWNER"),
    CREATE_CATALOG("CREATE CATALOG"),
    USE_CATALOG("USE CATALOG"),
    CREATE_SCHEMA("CREATE SCHEMA"),
    USE_SCHEMA("USE SCHEMA"),
    CREATE_TABLE("CREATE TABLE"),
    SELECT("SELECT"),
    MODIFY("MODIFY"),
    CREATE_FUNCTION("CREATE FUNCTION"),
    EXECUTE("EXECUTE"),
    CREATE_VOLUME("CREATE VOLUME"),
    READ_VOLUME("READ VOLUME"),
    CREATE_MODEL("CREATE MODEL");

    private String value;

    private Privileges(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Privileges fromValue(String value) {
        for (Privileges b : Privileges.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static Privilege toPrivilege(Privileges privilege) {
        try {
            return Privilege.fromValue(privilege.getValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Privileges fromPrivilege(Privilege privilege) {
        try {
            return Privileges.fromValue(privilege.getValue());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

