/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.utils;

import io.unitycatalog.server.persist.dao.CatalogInfoDAO;
import io.unitycatalog.server.persist.dao.ColumnInfoDAO;
import io.unitycatalog.server.persist.dao.CredentialDAO;
import io.unitycatalog.server.persist.dao.ExternalLocationDAO;
import io.unitycatalog.server.persist.dao.FunctionInfoDAO;
import io.unitycatalog.server.persist.dao.FunctionParameterInfoDAO;
import io.unitycatalog.server.persist.dao.MetastoreDAO;
import io.unitycatalog.server.persist.dao.ModelVersionInfoDAO;
import io.unitycatalog.server.persist.dao.PropertyDAO;
import io.unitycatalog.server.persist.dao.RegisteredModelInfoDAO;
import io.unitycatalog.server.persist.dao.SchemaInfoDAO;
import io.unitycatalog.server.persist.dao.TableInfoDAO;
import io.unitycatalog.server.persist.dao.UserDAO;
import io.unitycatalog.server.persist.dao.VolumeInfoDAO;
import io.unitycatalog.server.utils.ServerProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(HibernateConfigurator.class);
    private final SessionFactory sessionFactory;
    private final Properties hibernateProperties;

    public HibernateConfigurator(ServerProperties serverProperties) {
        this.hibernateProperties = HibernateConfigurator.setupHibernateProperties(serverProperties);
        this.sessionFactory = HibernateConfigurator.createSessionFactory(this.hibernateProperties);
    }

    private static SessionFactory createSessionFactory(Properties hibernateProperties) {
        try {
            Configuration configuration = new Configuration().setProperties(hibernateProperties);
            configuration.addAnnotatedClass(CatalogInfoDAO.class);
            configuration.addAnnotatedClass(SchemaInfoDAO.class);
            configuration.addAnnotatedClass(TableInfoDAO.class);
            configuration.addAnnotatedClass(ColumnInfoDAO.class);
            configuration.addAnnotatedClass(PropertyDAO.class);
            configuration.addAnnotatedClass(FunctionInfoDAO.class);
            configuration.addAnnotatedClass(RegisteredModelInfoDAO.class);
            configuration.addAnnotatedClass(ModelVersionInfoDAO.class);
            configuration.addAnnotatedClass(FunctionParameterInfoDAO.class);
            configuration.addAnnotatedClass(VolumeInfoDAO.class);
            configuration.addAnnotatedClass(UserDAO.class);
            configuration.addAnnotatedClass(MetastoreDAO.class);
            configuration.addAnnotatedClass(CredentialDAO.class);
            configuration.addAnnotatedClass(ExternalLocationDAO.class);
            StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(configuration.getProperties()).build();
            return configuration.buildSessionFactory((ServiceRegistry)serviceRegistry);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception during creation of SessionFactory", e);
        }
    }

    public static Properties setupHibernateProperties(ServerProperties serverProperties) {
        Path hibernatePropertiesPath = Paths.get("etc/conf/hibernate.properties", new String[0]);
        Properties hibernateProperties = new Properties();
        if (!hibernatePropertiesPath.toFile().exists()) {
            LOGGER.warn("Hibernate properties file not found: {}", (Object)hibernatePropertiesPath);
            hibernateProperties.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
            hibernateProperties.setProperty("hibernate.connection.url", "jdbc:h2:mem:testdb;DB_CLOSE_DELAY=-1");
            hibernateProperties.setProperty("hibernate.hbm2ddl.auto", "update");
        } else {
            try {
                InputStream input = Files.newInputStream(hibernatePropertiesPath, new OpenOption[0]);
                hibernateProperties.load(input);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if ("test".equals(serverProperties.getProperty("server.env"))) {
            hibernateProperties.setProperty("hibernate.connection.driver_class", "org.h2.Driver");
            hibernateProperties.setProperty("hibernate.connection.url", "jdbc:h2:mem:testdb;DB_CLOSE_DELAY=-1");
            hibernateProperties.setProperty("hibernate.hbm2ddl.auto", "create-drop");
            LOGGER.debug("Hibernate configuration set for testing");
        }
        return hibernateProperties;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Properties getHibernateProperties() {
        return this.hibernateProperties;
    }
}

