/*
 * Decompiled with CFR 0.152.
 */
package io.unitycatalog.server.persist.utils;

import io.unitycatalog.server.exception.BaseException;
import io.unitycatalog.server.exception.ErrorCode;
import io.unitycatalog.server.persist.dao.IdentifiableDAO;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;

public class PagedListingHelper<T extends IdentifiableDAO> {
    private final Class<T> entityClass;
    public static final Integer DEFAULT_PAGE_SIZE = 100;

    public PagedListingHelper(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public static Integer getPageSize(Optional<Integer> maxResults) {
        return maxResults.filter(x -> x > 0).map(x -> Math.min(x, DEFAULT_PAGE_SIZE)).orElse(DEFAULT_PAGE_SIZE);
    }

    public String getNextPageToken(List<T> entities, Optional<Integer> maxResults) {
        if (entities == null || entities.isEmpty() || entities.size() < PagedListingHelper.getPageSize(maxResults)) {
            return null;
        }
        return ((IdentifiableDAO)entities.get(entities.size() - 1)).getName();
    }

    public Query<T> buildListQuery(Session session, UUID parentEntityId, String pageToken) {
        HibernateCriteriaBuilder cb = session.getCriteriaBuilder();
        CriteriaQuery cr = cb.createQuery(this.entityClass);
        Root root = cr.from(this.entityClass);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Optional<String> parentEntityIdColumn = IdentifiableDAO.getParentIdColumnName(this.entityClass);
        parentEntityIdColumn.ifPresent(arg_0 -> PagedListingHelper.lambda$buildListQuery$2(predicates, (CriteriaBuilder)cb, root, parentEntityId, arg_0));
        predicates.add(cb.or((Expression)cb.greaterThan((Expression)root.get("name"), (Comparable)((Object)pageToken)), (Expression)cb.isNull(cb.literal((Object)pageToken))));
        Predicate combinedPredicate = cb.and(predicates.toArray(new Predicate[0]));
        cr.select((Selection)root).where((Expression)combinedPredicate).orderBy(new Order[]{cb.asc((Expression)root.get("name"))});
        return session.createQuery(cr);
    }

    public List<T> listEntity(Session session, Optional<Integer> maxResultsOpt, Optional<String> nextPageTokenOpt, UUID parentEntityId) {
        if (maxResultsOpt.isPresent() && maxResultsOpt.get() < 0) {
            throw new BaseException(ErrorCode.INVALID_ARGUMENT, "maxResults must be greater than or equal to 0");
        }
        Integer pageSize = PagedListingHelper.getPageSize(maxResultsOpt);
        Query<T> query = this.buildListQuery(session, parentEntityId, nextPageTokenOpt.orElse(null));
        query.setMaxResults(pageSize.intValue());
        return query.getResultList();
    }

    private static /* synthetic */ void lambda$buildListQuery$2(List predicates, CriteriaBuilder cb, Root root, UUID parentEntityId, String s) {
        predicates.add(cb.equal((Expression)root.get(s), (Object)parentEntityId));
    }
}

